/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.drilldown.filter;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dto.multivalue.MultivalueField;
import org.cxbox.core.dto.multivalue.MultivalueFieldSingleValue;
import org.cxbox.core.util.JsonUtils;
import org.cxbox.dictionary.Dictionary;

public class PlatformDrilldownFilterService {
    private static final String AMPERSAND_URL_ENCODED = URLEncoder.encode("&", StandardCharsets.UTF_8);

    public Optional<String> formUrlPart(BcIdentifier bc, Collection<String> fieldsFilterString) {
        List<String> cleanedList = fieldsFilterString.stream().filter(Objects::nonNull).filter(StringUtils::isNotEmpty).toList();
        if (cleanedList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of("\"" + bc.getName() + "\":\"" + String.join((CharSequence)AMPERSAND_URL_ENCODED, cleanedList) + "\"");
    }

    public <D extends DataResponseDTO> String input(@NonNull DtoField<? super D, String> field, @Nullable String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Dictionary> String dictionary(@NonNull DtoField<? super D, T> field, @Nullable T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.arrayValue(SearchOperation.EQUALS_ONE_OF, true, field, List.of(value));
    }

    public <D extends DataResponseDTO, T extends Dictionary> String dictionary(@NonNull DtoField<? super D, T> field, @Nullable Collection<T> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null || values.isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.arrayValue(SearchOperation.EQUALS_ONE_OF, true, field, values);
    }

    public <D extends DataResponseDTO, T extends Enum<?>> String dictionaryEnum(@NonNull DtoField<? super D, T> field, @Nullable T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.arrayValue(SearchOperation.EQUALS_ONE_OF, true, field, List.of(value));
    }

    public <D extends DataResponseDTO, T extends Enum<?>> String dictionaryEnum(@NonNull DtoField<? super D, T> field, @Nullable Collection<T> values) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (values == null || values.isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.arrayValue(SearchOperation.EQUALS_ONE_OF, true, field, values);
    }

    private <D extends DataResponseDTO> String dateFromFilter(@NonNull DtoField<? super D, LocalDateTime> field, @NonNull LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.GREATER_OR_EQUAL_THAN, true, field, value);
    }

    private <D extends DataResponseDTO> String dateToFilter(@NonNull DtoField<? super D, LocalDateTime> field, @NonNull LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.LESS_OR_EQUAL_THAN, true, field, value);
    }

    public <D extends DataResponseDTO> String date(@NonNull DtoField<? super D, LocalDateTime> field, @Nullable LocalDate value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return this.dateFromTo(field, value, value);
    }

    public <D extends DataResponseDTO> String dateFromTo(@NonNull DtoField<? super D, LocalDateTime> field, @Nullable LocalDate from, @Nullable LocalDate to) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (from != null && to != null) {
            return this.dateFromFilter(field, from.atStartOfDay()) + AMPERSAND_URL_ENCODED + this.dateToFilter(field, to.atTime(23, 59, 59));
        }
        if (from != null) {
            return this.dateFromFilter(field, from.atStartOfDay());
        }
        if (to != null) {
            return this.dateToFilter(field, to.atTime(23, 59, 59));
        }
        return null;
    }

    public <D extends DataResponseDTO> String dateTime(@NonNull DtoField<? super D, LocalDateTime> field, @Nullable LocalDateTime value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return this.dateTimeFromTo(field, value, value);
    }

    public <D extends DataResponseDTO> String dateTimeFromTo(@NonNull DtoField<? super D, LocalDateTime> field, @Nullable LocalDateTime from, @Nullable LocalDateTime to) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (from != null && to != null) {
            return this.dateFromFilter(field, from) + AMPERSAND_URL_ENCODED + this.dateToFilter(field, to);
        }
        if (from != null) {
            return this.dateFromFilter(field, from);
        }
        if (to != null) {
            return this.dateToFilter(field, to);
        }
        return null;
    }

    public <D extends DataResponseDTO> String multiValue(@NonNull DtoField<? super D, MultivalueField> field, @Nullable MultivalueField value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null || value.getValues().isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.multivalue(SearchOperation.EQUALS_ONE_OF, field, value, MultivalueFieldSingleValue::getId);
    }

    public <D extends DataResponseDTO, T extends Number> String number(@NonNull DtoField<? super D, T> field, T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.EQUALS, field, value);
    }

    public <D extends DataResponseDTO, T extends Number> String numberFromTo(@NonNull DtoField<? super D, T> field, @Nullable T from, @Nullable T to) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (from == null && to == null) {
            return null;
        }
        if (from != null && to == null) {
            return this.numberFrom(field, from);
        }
        if (from == null) {
            return this.numberTo(field, to);
        }
        return this.numberFrom(field, from) + AMPERSAND_URL_ENCODED + this.numberTo(field, to);
    }

    private <D extends DataResponseDTO, T extends Number> String numberFrom(@NonNull DtoField<? super D, T> field, @NonNull T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.GREATER_OR_EQUAL_THAN, field, value);
    }

    private <D extends DataResponseDTO, T extends Number> String numberTo(@NonNull DtoField<? super D, T> field, @NonNull T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.LESS_OR_EQUAL_THAN, field, value);
    }

    public <D extends DataResponseDTO, T extends Number> String percent(@NonNull DtoField<? super D, T> field, T value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.EQUALS, field, value);
    }

    public <D extends DataResponseDTO, T extends Number> String percentFromTo(@NonNull DtoField<? super D, T> field, T from, T to) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (from == null && to == null) {
            return null;
        }
        if (from != null && to == null) {
            return this.numberFrom(field, from);
        }
        if (from == null) {
            return this.numberTo(field, to);
        }
        return this.numberFrom(field, from) + AMPERSAND_URL_ENCODED + this.numberTo(field, to);
    }

    public <D extends DataResponseDTO> String text(@NonNull DtoField<? super D, String> field, String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Enum<?>> String radio(@NotNull DtoField<? super D, T> field, Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.arrayValue(SearchOperation.EQUALS_ONE_OF, true, field, values);
    }

    public <D extends DataResponseDTO> String checkbox(@NotNull DtoField<? super D, Boolean> field, Boolean value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.SPECIFIED, field, value);
    }

    public <D extends DataResponseDTO, T extends Number> String money(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.EQUALS, field, value);
    }

    public <D extends DataResponseDTO, T extends Number> String moneyFromTo(@NotNull DtoField<? super D, T> field, T from, T to) {
        if (from == null && to == null) {
            return null;
        }
        if (from != null && to == null) {
            return this.numberFrom(field, from);
        }
        if (from == null) {
            return this.numberTo(field, to);
        }
        return this.numberFrom(field, from) + AMPERSAND_URL_ENCODED + this.numberTo(field, to);
    }

    public <D extends DataResponseDTO, T extends Serializable> String fileUpload(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Serializable> String pickList(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Serializable> String inlinePickList(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Serializable> String multifield(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends Serializable> String suggestionPickList(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.singleValue(SearchOperation.CONTAINS, field, value);
    }

    public <D extends DataResponseDTO, T extends MultivalueField> String multivalueHover(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null || value.getValues().isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.multivalue(SearchOperation.EQUALS_ONE_OF, field, value, MultivalueFieldSingleValue::getId);
    }

    public <D extends DataResponseDTO, T extends MultivalueField> String multipleSelect(@NotNull DtoField<? super D, T> field, T value) {
        if (value == null || value.getValues().isEmpty()) {
            return null;
        }
        return DrillDownFieldFilterFormerUtils.multivalue(SearchOperation.EQUALS_ONE_OF, field, value, MultivalueFieldSingleValue::getValue);
    }

    public static final class DrillDownFieldFilterFormerUtils {
        private DrillDownFieldFilterFormerUtils() {
        }

        public static <D, T> String singleValue(@NotNull SearchOperation operation, @NotNull DtoField<? super D, T> field, @NotNull T value) {
            return DrillDownFieldFilterFormerUtils.singleValue(operation, false, field, value);
        }

        public static <D, T> String singleValue(@NotNull SearchOperation operation, boolean isJsonSerialization, @NotNull DtoField<? super D, T> field, @NotNull T value) {
            String rawValue = isJsonSerialization ? DrillDownFieldFilterFormerUtils.stripQuotes(JsonUtils.writeValue(value)) : String.valueOf(value);
            String expression = field.getName() + "." + operation.getOperationName() + "=" + rawValue;
            return URLEncoder.encode(expression, StandardCharsets.UTF_8);
        }

        public static <D, T> String arrayValue(@NotNull SearchOperation operation, @NotNull DtoField<? super D, T> field, @NotNull Collection<T> values) {
            return DrillDownFieldFilterFormerUtils.arrayValue(operation, false, field, values);
        }

        public static <D, T> String arrayValue(@NotNull SearchOperation operation, boolean isJsonSerialization, @NotNull DtoField<? super D, T> field, @NotNull Collection<T> values) {
            String joined = values.stream().map(val -> {
                String repr = isJsonSerialization ? DrillDownFieldFilterFormerUtils.stripQuotes(JsonUtils.writeValue(val)) : String.valueOf(val);
                return URLEncoder.encode(repr, StandardCharsets.UTF_8);
            }).collect(Collectors.joining(","));
            String expression = field.getName() + "." + operation.getOperationName() + "=[\\\"" + joined + "\\\"]";
            return URLEncoder.encode(expression, StandardCharsets.UTF_8);
        }

        public static <D, T extends MultivalueField> String multivalue(@NotNull SearchOperation operation, @NotNull DtoField<? super D, T> field, @NotNull T multivalue, @NotNull Function<MultivalueFieldSingleValue, String> extractor) {
            String joined = multivalue.getValues().stream().map(extractor).map(val -> URLEncoder.encode(val, StandardCharsets.UTF_8)).collect(Collectors.joining("\\\",\\\""));
            String expression = field.getName() + "." + operation.getOperationName() + "=[\\\"" + joined + "\\\"]";
            return URLEncoder.encode(expression, StandardCharsets.UTF_8);
        }

        private static String stripQuotes(String json) {
            if (json.length() >= 2 && json.startsWith("\"") && json.endsWith("\"")) {
                return json.substring(1, json.length() - 1);
            }
            return json;
        }
    }
}

