/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.rowmeta;

import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.PlatformRequest;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceBcDescription;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.ExtremeBcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.rowmeta.FieldsMeta;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.cxbox.core.external.core.ParentDtoFirstLevelCache;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AnySourceFieldMetaBuilder<T extends DataResponseDTO> {
    @Autowired
    private PlatformRequest platformRequest;
    @Autowired
    private ParentDtoFirstLevelCache parentDtoFirstLevelCache;

    public void buildRowDependentMeta(RowDependentFieldsMeta<T> fields, BusinessComponent bc) {
        if (bc.getDescription() instanceof InnerBcDescription) {
            this.buildRowDependentMeta(fields, (BcDescription)bc.getDescription(), bc.getId(), bc.getParentId());
        } else if (bc.getDescription() instanceof AnySourceBcDescription) {
            this.buildRowDependentMeta(fields, (BcDescription)bc.getDescription(), bc.getId(), bc.getParentId());
        } else if (bc.getDescription() instanceof ExtremeBcDescription) {
            this.buildExtremeRowDependentMeta(fields, (BcDescription)bc.getDescription(), bc.getId(), bc.getParentId());
        }
    }

    public void buildIndependentMeta(FieldsMeta<T> fields, BusinessComponent bc) {
        this.buildIndependentMeta(fields, (BcDescription)bc.getDescription(), bc.getParentId());
    }

    public abstract void buildRowDependentMeta(RowDependentFieldsMeta<T> var1, BcDescription var2, String var3, String var4);

    public void buildExtremeRowDependentMeta(RowDependentFieldsMeta<T> fields, BcDescription bcDescription, String id, String parentId) {
    }

    public abstract void buildIndependentMeta(FieldsMeta<T> var1, BcDescription var2, String var3);

    public <P extends DataResponseDTO, F> F getParentField(DtoField<P, F> dtoField, BusinessComponent bc) {
        return this.parentDtoFirstLevelCache.getParentField(dtoField, bc);
    }

    public CrudmaActionType getActionType() {
        return this.platformRequest.getCrudmaActionType();
    }

    public BusinessComponent getBc() {
        return this.platformRequest.getBc();
    }
}

