/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.config.properties.UIProperties;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.core.util.session.WebHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="sessionService")
public class SessionServiceImpl
implements SessionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionServiceImpl.class);
    private final CoreSessionService coreSessionService;
    private final UIProperties uiProperties;

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public IUser<Long> getSessionUser() {
        return this.coreSessionService.getSessionUserDetails(true);
    }

    @Override
    public Long getSessionUserDepartmentId() {
        return (Long)this.getSessionUser().getDepartmentId();
    }

    @Override
    @Deprecated
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public String getSessionUserRole() {
        if (!this.uiProperties.isMultiRoleEnabled()) {
            CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
            HttpServletRequest request = WebHelper.getCurrentRequest().orElse(null);
            if (request == null) {
                return userDetails.getUserRoles().stream().findFirst().orElse(null);
            }
            return this.calculateUserRole(request, userDetails);
        }
        throw new IllegalStateException("Method is not allowed, when cxbox.ui.isMultiRoleEnabled = true. Please, use List<String> getSessionUserRoles() instead");
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    @NonNull
    public Set<String> getSessionUserRoles() {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        Set userRoles = userDetails.getUserRoles();
        if (userRoles.isEmpty()) {
            String res = SessionServiceImpl.getRequestedRoleOrElseMain(userDetails, null);
            return res == null ? new HashSet<String>() : new HashSet<String>(Set.of(res));
        }
        return userRoles;
    }

    private String calculateUserRole(@NonNull HttpServletRequest request, @NonNull CxboxUserDetailsInterface userDetails) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (userDetails == null) {
            throw new NullPointerException("userDetails is marked non-null but is null");
        }
        String requestedRole = request.getHeader("RequestedUserRole");
        return SessionServiceImpl.getRequestedRoleOrElseMain(userDetails, requestedRole);
    }

    @Nullable
    private static String getRequestedRoleOrElseMain(@NonNull CxboxUserDetailsInterface user, @Nullable String requested) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        String mainRole = user.getUserRoles().stream().findFirst().orElse(null);
        if (StringUtils.isBlank((CharSequence)requested) || requested.equals(mainRole)) {
            return mainRole;
        }
        return requested;
    }

    @Override
    public String getSessionId() {
        return this.coreSessionService.getSessionId();
    }

    @ConstructorProperties(value={"coreSessionService", "uiProperties"})
    @Generated
    public SessionServiceImpl(CoreSessionService coreSessionService, UIProperties uiProperties) {
        this.coreSessionService = coreSessionService;
        this.uiProperties = uiProperties;
    }
}

