/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl;

import java.beans.ConstructorProperties;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.AssociateDTO;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceCrudmaImplementation;
import org.cxbox.core.crudma.impl.inner.AnySourceCrudmaService;
import org.cxbox.core.dao.AnySourceBaseDAO;
import org.cxbox.core.dto.PreInvokeEvent;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.ActionsDTO;
import org.cxbox.core.dto.rowmeta.AssociateResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.exception.EntityNotFoundException;
import org.cxbox.core.exception.UnconfirmedException;
import org.cxbox.core.service.AnySourceDTOMapper;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.action.ActionDescription;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.action.AssocPreActionEventParameters;
import org.cxbox.core.service.action.DataResponsePreActionEventParameters;
import org.cxbox.core.service.action.PreActionCondition;
import org.cxbox.core.service.action.PreActionConditionHolderAssoc;
import org.cxbox.core.service.action.PreActionConditionHolderDataResponse;
import org.cxbox.core.service.action.PreActionEvent;
import org.cxbox.core.service.action.PreActionEventChecker;
import org.cxbox.core.service.rowmeta.AnySourceFieldMetaBuilder;
import org.cxbox.core.service.rowmeta.RowMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@AnySourceCrudmaImplementation(value=AnySourceCrudmaService.class)
public abstract class AbstractAnySourceResponseService<T extends DataResponseDTO, E>
implements AnySourceResponseService<T, E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAnySourceResponseService.class);
    protected final Class<T> typeOfDTO;
    protected final Class<E> typeOfEntity;
    private final Class<? extends AnySourceFieldMetaBuilder<T>> metaBuilder;
    protected final Class<? extends AnySourceBaseDAO<E>> anySourceBaseDAOClass;
    protected Class<? extends PreActionConditionHolderDataResponse<T>> preActionConditionHolderDataResponse = null;
    protected Class<? extends PreActionConditionHolderAssoc> preActionConditionHolderAssoc = null;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private AnySourceDTOMapper dtoMapper;
    @Autowired
    private List<AnySourceBaseDAO<E>> anySourceBaseDAOs;

    @Override
    public AnySourceBaseDAO<E> getBaseDao() {
        return this.anySourceBaseDAOs.stream().filter(dao -> this.anySourceBaseDAOClass.isAssignableFrom(dao.getClass())).findFirst().orElseThrow();
    }

    public static <T> T cast(Object o, Class<T> clazz) {
        return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
    }

    public final <D, V> void setMappedIfChanged(T dto, DtoField<? super T, D> dtoField, Consumer<V> entitySetter, Supplier<D> dtoGetter, Function<D, V> mapper) {
        if (dto.isFieldChanged(dtoField)) {
            entitySetter.accept(mapper.apply(dtoGetter.get()));
        }
    }

    public final <V> void setIfChanged(T dto, DtoField<? super T, V> dtoField, Consumer<V> entitySetter, Supplier<V> dtoGetter) {
        this.setMappedIfChanged(dto, dtoField, entitySetter, dtoGetter, Function.identity());
    }

    public final <D, V> void setMappedIfChanged(T dto, DtoField<? super T, D> dtoField, Consumer<V> entitySetter, Function<D, V> mapper) {
        this.setMappedIfChanged(dto, dtoField, entitySetter, () -> dtoField.getValue(dto), mapper);
    }

    public final <V> void setIfChanged(T dto, DtoField<? super T, V> dtoField, Consumer<V> entitySetter) {
        this.setMappedIfChanged(dto, dtoField, entitySetter, Function.identity());
    }

    @Override
    public <V> V unwrap(Class<V> cls) {
        if (cls.isInstance(this)) {
            return (V)this;
        }
        throw new IllegalArgumentException(cls.getName());
    }

    @Override
    public boolean isDeferredCreationSupported(BusinessComponent bc) {
        return true;
    }

    @Override
    public boolean hasPersister() {
        return !this.typeOfEntity.isInterface() && !Modifier.isAbstract(this.typeOfEntity.getModifiers());
    }

    @Override
    public E getOneAsEntity(BusinessComponent bc) {
        return this.getBaseDao().getById(bc);
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="{#root.targetClass, #root.methodName, #bc.name, #bc.id}")
    public T getOne(BusinessComponent bc) {
        return this.doGetOne(bc);
    }

    protected T doGetOne(BusinessComponent bc) {
        return this.entityToDto(bc, this.getOneAsEntity(bc));
    }

    @Override
    public ActionResultDTO<T> deleteEntity(BusinessComponent bc) {
        this.getBaseDao().delete(bc);
        return new ActionResultDTO();
    }

    @Override
    public ResultPage<T> getList(BusinessComponent bc) {
        return this.entitiesToDtos(bc, ResultPage.of(this.getBaseDao().getList(bc, bc.getParameters()).stream().collect(Collectors.toList()), (boolean)false));
    }

    @Override
    public ActionsDTO getAvailableActions(RowMetaType metaType, DataResponseDTO data, BusinessComponent bc) {
        return this.getActions().toDto(bc);
    }

    @Override
    public ActionResultDTO onCancel(BusinessComponent bc) {
        return new ActionResultDTO().setAction(PostAction.postDelete());
    }

    @Override
    public ActionResultDTO<T> invokeAction(BusinessComponent bc, String actionName, DataResponseDTO data) {
        ActionDescription<DataResponseDTO> action = this.getActions().getAction(actionName);
        if (action == null || !action.isAvailable(bc)) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.action_unavailable", (Object[])new Object[]{actionName}));
        }
        this.preInvoke(bc, action.withPreActionEvents(bc), data, null);
        Object record = null;
        if (Objects.nonNull(bc.getId())) {
            if (action.isAutoSaveBefore() && Objects.nonNull(data) && data.hasChangedFields()) {
                record = this.updateEntity(bc, data).getRecord();
            } else {
                if (action.isUpdateRequired() && this.hasPersister()) {
                    this.loadEntity(bc, data);
                }
                record = this.doGetOne(bc);
            }
        }
        return action.invoke(bc, Optional.ofNullable(record).orElse(data));
    }

    private void preInvoke(BusinessComponent bc, List<PreActionEvent> preActionEvents, DataResponseDTO data, AssociateDTO associateDTO) {
        List<String> preInvokeParameters = bc.getPreInvokeParameters();
        ArrayList<PreInvokeEvent> preInvokeEvents = new ArrayList<PreInvokeEvent>();
        if (Objects.nonNull(preActionEvents)) {
            preActionEvents.forEach(preActionEvent -> {
                if (Objects.nonNull(preActionEvent) && !preInvokeParameters.contains(preActionEvent.getKey()) && (data == null ? this.getCheckerAssoc(preActionEvent.getPreActionCondition()).check(new AssocPreActionEventParameters(associateDTO, bc, preInvokeParameters)) : this.getCheckerData(preActionEvent.getPreActionCondition()).check(new DataResponsePreActionEventParameters<DataResponseDTO>(data, bc, preInvokeParameters)))) {
                    preInvokeEvents.add(PreInvokeEvent.of(preActionEvent.getKey(), preActionEvent.getType().getKey(), preActionEvent.getMessage()));
                }
            });
        }
        if (!preInvokeEvents.isEmpty()) {
            throw new UnconfirmedException().addPreInvokeEvents(preInvokeEvents);
        }
    }

    private PreActionEventChecker<T> getCheckerData(PreActionCondition preActionCondition) {
        if (Objects.nonNull(this.preActionConditionHolderDataResponse)) {
            PreActionEventChecker checker = ((PreActionConditionHolderDataResponse)this.applicationContext.getBean(this.preActionConditionHolderDataResponse)).getChecker(preActionCondition);
            if (Objects.nonNull(checker)) {
                return checker;
            }
            throw new ServerException("PreActionHolder in " + this.getClass().getSimpleName() + "doesn't have checker for " + preActionCondition.getName() + "preAction");
        }
        throw new ServerException("PreActionConditionHolder is null for " + preActionCondition.getName() + " preaction in " + this.getClass().getSimpleName() + " service");
    }

    private PreActionEventChecker<AssociateDTO> getCheckerAssoc(PreActionCondition preActionCondition) {
        if (Objects.nonNull(this.preActionConditionHolderAssoc)) {
            PreActionEventChecker<AssociateDTO> checker = ((PreActionConditionHolderAssoc)this.applicationContext.getBean(this.preActionConditionHolderAssoc)).getChecker(preActionCondition);
            if (Objects.nonNull(checker)) {
                return checker;
            }
            throw new ServerException("PreActionHolder in " + this.getClass().getSimpleName() + "doesn't have checker for " + preActionCondition.getName() + "preAction");
        }
        throw new ServerException("PreActionConditionHolder is null for " + preActionCondition.getName() + " preaction in " + this.getClass().getSimpleName() + " service");
    }

    @Override
    public long count(BusinessComponent bc) {
        return this.getBaseDao().count(bc);
    }

    @Override
    public void validate(BusinessComponent bc, DataResponseDTO data) {
        T entityDto = this.entityToDto(bc, this.getOneAsEntity(bc));
        this.updateDataDto(data, entityDto);
        ActionDescription<T> save = this.getActions().getAction(ActionType.SAVE.getType());
        if (Objects.nonNull(save)) {
            this.popup(save.validate(bc, data, entityDto));
            List<PreActionEvent> preActionEvents = save.withPreActionEvents(bc);
            this.preInvoke(bc, Objects.nonNull(preActionEvents) ? preActionEvents : this.getPreActionsForSave(), data, null);
        }
    }

    private void popup(List<String> messages) {
        if (Objects.nonNull(messages) && !messages.isEmpty()) {
            throw new BusinessException().addPopup(messages);
        }
    }

    @Override
    public Actions<T> getActions() {
        return Actions.builder().action("drillDown", "\u041f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u0442\u044c \u0444\u043e\u0440\u043c\u0443").available(bc -> false).invoker((bc, data) -> null).add(false).build();
    }

    protected List<PreActionEvent> getPreActionsForSave() {
        return Collections.emptyList();
    }

    protected ResultPage<T> entitiesToDtos(BusinessComponent bc, ResultPage<E> entities) {
        return ResultPage.of(entities, e -> this.entityToDto(bc, e));
    }

    @Override
    public T entityToDto(BusinessComponent bc, E entity) {
        return this.dtoMapper.entityToDto(bc, entity, this.typeOfDTO);
    }

    private void updateDataDto(DataResponseDTO data, T entityDto) {
        DataResponseDTO updatedDto = (DataResponseDTO)AbstractAnySourceResponseService.cast(data, this.typeOfDTO);
        Stream.of(entityDto.getClass().getDeclaredFields()).filter(field -> !data.isFieldChanged(field.getName())).forEach(field -> {
            field.setAccessible(true);
            try {
                field.set(updatedDto, this.getValue(field.getName(), entityDto));
            }
            catch (IllegalAccessException e) {
                log.error(e.getLocalizedMessage());
            }
        });
    }

    private Object getValue(String fieldName, T data) {
        if (Objects.isNull(data)) {
            return null;
        }
        AtomicReference value = new AtomicReference();
        Stream.of(data.getClass().getDeclaredFields()).filter(field -> field.getName().equals(fieldName)).findFirst().ifPresent(field -> {
            field.setAccessible(true);
            try {
                value.set(field.get(data));
            }
            catch (IllegalAccessException e) {
                log.error(e.getLocalizedMessage());
            }
        });
        return value.get();
    }

    @Deprecated
    protected ResultPage<E> entityListToResultPage(List<E> entities, int limit) {
        boolean hasNext;
        int size = entities.size();
        if (size == limit + 1) {
            entities.remove(size - 1);
            hasNext = true;
        } else {
            hasNext = false;
        }
        return new ResultPage(entities, hasNext);
    }

    protected ResultPage<T> dtoListToResultPage(List<T> dtos, int limit) {
        boolean hasNext;
        int size = dtos.size();
        if (size == limit + 1) {
            dtos.remove(size - 1);
            hasNext = true;
        } else {
            hasNext = false;
        }
        return new ResultPage(dtos, hasNext);
    }

    protected final E isExist(BusinessComponent bc) {
        E entity = this.getBaseDao().getById(bc);
        if (entity == null) {
            throw new EntityNotFoundException(this.typeOfEntity.getSimpleName(), bc.getIdAsLong());
        }
        return entity;
    }

    protected E loadEntity(BusinessComponent bc, DataResponseDTO data) {
        return this.getOneAsEntity(bc);
    }

    @Override
    public Class<? extends AnySourceFieldMetaBuilder<T>> getAnySourceFieldMetaBuilder() {
        return this.metaBuilder;
    }

    @Override
    public ActionResultDTO<T> updateEntity(BusinessComponent bc, DataResponseDTO data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ActionResultDTO<T> preview(BusinessComponent bc, DataResponseDTO data) {
        return this.updateEntity(bc, data);
    }

    @Override
    public CreateResult<T> createEntity(BusinessComponent bc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AssociateResultDTO associate(List<AssociateDTO> data, BusinessComponent bc) {
        ActionDescription<T> associate = this.getActions().getAction(ActionType.ASSOCIATE.getType());
        if (Objects.nonNull(associate)) {
            data.stream().filter(AssociateDTO::getAssociated).forEach(dto -> this.preInvoke(bc, associate.withPreActionEvents(bc), null, (AssociateDTO)dto));
        }
        return this.doAssociate(data, bc);
    }

    protected AssociateResultDTO doAssociate(List<AssociateDTO> data, BusinessComponent bc) {
        throw new UnsupportedOperationException();
    }

    @ConstructorProperties(value={"typeOfDTO", "typeOfEntity", "metaBuilder", "anySourceBaseDAOClass"})
    @Generated
    public AbstractAnySourceResponseService(Class<T> typeOfDTO, Class<E> typeOfEntity, Class<? extends AnySourceFieldMetaBuilder<T>> metaBuilder, Class<? extends AnySourceBaseDAO<E>> anySourceBaseDAOClass) {
        this.typeOfDTO = typeOfDTO;
        this.typeOfEntity = typeOfEntity;
        this.metaBuilder = metaBuilder;
        this.anySourceBaseDAOClass = anySourceBaseDAOClass;
    }

    @Override
    @Generated
    public Class<T> getTypeOfDTO() {
        return this.typeOfDTO;
    }

    @Override
    @Generated
    public Class<E> getTypeOfEntity() {
        return this.typeOfEntity;
    }

    @Generated
    public Class<? extends AnySourceBaseDAO<E>> getAnySourceBaseDAOClass() {
        return this.anySourceBaseDAOClass;
    }
}

