/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.exception.ServerException;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.controller.param.SortParameter;
import org.cxbox.core.controller.param.SortParameters;
import org.cxbox.core.util.TypeConverter;

public final class ListPaging {
    public static <T extends DataResponseDTO> ResultPage<T> getResultPage(List<T> list, QueryParameters queryParameters) {
        Stream stream = list.stream();
        for (FilterParameter parameter : queryParameters.getFilter()) {
            stream = stream.filter(ListPaging.createFilter(parameter));
        }
        if (!queryParameters.getSort().isEmpty()) {
            stream = stream.sorted(ListPaging.createSorted(queryParameters.getSort()));
        }
        List filteredList = stream.collect(Collectors.toList());
        long from = (long)queryParameters.getPageNumber() * (long)queryParameters.getPageSize();
        long to = from + (long)queryParameters.getPageSize();
        if (to > (long)filteredList.size()) {
            to = filteredList.size();
        }
        return new ResultPage(filteredList.subList((int)from, (int)to), (long)filteredList.size() > to);
    }

    private static <T> Predicate<T> createFilter(FilterParameter parameter) {
        switch (parameter.getOperation()) {
            case CONTAINS: {
                return new PredicateContains(parameter);
            }
            case SPECIFIED: {
                return new PredicateSpecified(parameter);
            }
            case EQUALS: {
                return new PredicateEquals(parameter);
            }
            case GREATER_THAN: {
                return new PredicateGreaterThan(parameter);
            }
            case GREATER_OR_EQUAL_THAN: {
                return new PredicateGreaterOrEqualThan(parameter);
            }
            case LESS_THAN: {
                return new PredicateLessThan(parameter);
            }
            case LESS_OR_EQUAL_THAN: {
                return new PredicateLessOrEqualThan(parameter);
            }
            case EQUALS_ONE_OF: {
                return new PredicateEqualsOneOf(parameter);
            }
            case CONTAINS_ONE_OF: {
                return new PredicateContainsOneOf(parameter);
            }
        }
        throw new ServerException(String.format("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", new Object[]{parameter.getOperation()}));
    }

    private static <T> Comparator<T> createSorted(SortParameters sort) {
        ArrayList sortedParameters = new ArrayList(sort.getParameters());
        sortedParameters.sort(ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.naturalComparator()), SortParameter::getPriority));
        Comparator[] comparators = new Comparator[sortedParameters.size()];
        for (int i = 0; i < sortedParameters.size(); ++i) {
            comparators[i] = ListPaging.createSorted((SortParameter)sortedParameters.get(i));
        }
        return ComparatorUtils.chainedComparator((Comparator[])comparators);
    }

    private static Comparator createSorted(SortParameter parameter) {
        FieldTransformer fieldTransformer = new FieldTransformer(parameter.getName());
        switch (parameter.getType()) {
            case ASC: {
                return ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.naturalComparator()), (Transformer)fieldTransformer);
            }
            case DESC: {
                return ComparatorUtils.transformedComparator((Comparator)ComparatorUtils.nullHighComparator((Comparator)ComparatorUtils.reversedComparator((Comparator)ComparatorUtils.naturalComparator())), (Transformer)fieldTransformer);
            }
        }
        throw new ServerException(String.format("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \"%s\" \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", new Object[]{parameter.getType()}));
    }

    private static Object getValue(Object dto, String fieldName) {
        try {
            return FieldUtils.getField(dto.getClass(), (String)fieldName, (boolean)true).get(dto);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    private ListPaging() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class PredicateContains<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof String && StringUtils.containsIgnoreCase((CharSequence)((String)value), (CharSequence)this.parameter.getStringValue());
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateContains(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateSpecified<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return BooleanUtils.isNotFalse((Boolean)this.parameter.getBooleanValue()) ? Objects.nonNull(value) : Objects.isNull(value);
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateSpecified(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateEquals<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value != null && Objects.equals(value, this.parameter.getValue(value.getClass()));
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateEquals(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateGreaterThan<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && ((Comparable)value).compareTo(this.parameter.getValue(value.getClass())) > 0;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateGreaterThan(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateGreaterOrEqualThan<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && ((Comparable)value).compareTo(this.parameter.getValue(value.getClass())) >= 0;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateGreaterOrEqualThan(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateLessThan<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && ((Comparable)value).compareTo(this.parameter.getValue(value.getClass())) < 0;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateLessThan(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateLessOrEqualThan<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            return value instanceof Comparable && ((Comparable)value).compareTo(this.parameter.getValue(value.getClass())) <= 0;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateLessOrEqualThan(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateEqualsOneOf<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            for (String stringValue : this.parameter.getStringValuesAsList()) {
                if (value == null || !Objects.equals(value, TypeConverter.to(value.getClass(), stringValue))) continue;
                return true;
            }
            return false;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateEqualsOneOf(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class PredicateContainsOneOf<T>
    implements Predicate<T> {
        private final FilterParameter parameter;

        @Override
        public boolean test(T dto) {
            Object value = ListPaging.getValue(dto, this.parameter.getName());
            if (value instanceof String) {
                for (String stringValue : this.parameter.getStringValuesAsList()) {
                    if (!StringUtils.containsIgnoreCase((CharSequence)((String)value), (CharSequence)stringValue)) continue;
                    return true;
                }
            }
            return false;
        }

        @ConstructorProperties(value={"parameter"})
        @Generated
        public PredicateContainsOneOf(FilterParameter parameter) {
            this.parameter = parameter;
        }
    }

    private static final class FieldTransformer
    implements Transformer {
        private final String fieldName;

        public Object transform(Object input) {
            return ListPaging.getValue(input, this.fieldName);
        }

        @ConstructorProperties(value={"fieldName"})
        @Generated
        public FieldTransformer(String fieldName) {
            this.fieldName = fieldName;
        }
    }
}

