/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param.resolvers;

import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.core.controller.param.resolvers.AbstractParameterArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageParameterArgumentResolver
extends AbstractParameterArgumentResolver {
    public static PageSpecification extract(Map<String, ?> queryParametersMap) {
        String page = PageParameterArgumentResolver.getParameterValue(queryParametersMap.get("_page"));
        String limit = PageParameterArgumentResolver.getParameterValue(queryParametersMap.get("_limit"));
        if (limit == null && page == null) {
            return PageSpecification.DEFAULT;
        }
        return new PageSpecification(NumberUtils.toInt((String)page, (int)1) - 1, NumberUtils.toInt((String)limit, (int)5), true);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PageSpecification.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (!this.supportsParameter(parameter)) {
            return PageSpecification.DEFAULT;
        }
        return PageParameterArgumentResolver.extract(webRequest.getParameterMap());
    }
}

