/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma;

import java.util.List;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.crudma.CrudmaFactory;
import org.cxbox.core.crudma.CrudmaGateway;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceBcDescription;
import org.cxbox.core.crudma.ext.CrudmaGatewayInvokeExtensionProvider;
import org.cxbox.core.service.AnySourceResponseFactory;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.ResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class AnySourceCrudmaGateway
extends CrudmaGateway {
    @Autowired
    public AnySourceResponseFactory respFactory;

    public AnySourceCrudmaGateway(CrudmaFactory crudmaFactory, ResponseFactory respFactory, List<CrudmaGatewayInvokeExtensionProvider> extensionProviders) {
        super(crudmaFactory, respFactory, extensionProviders);
    }

    @Override
    public boolean isReadOnly(CrudmaActionHolder.CrudmaAction action) {
        boolean readOnly = super.isReadOnly(action);
        CrudmaActionType actionType = action.getActionType();
        BusinessComponent bc = action.getBc();
        Object description = bc.getDescription();
        if (description instanceof AnySourceBcDescription) {
            readOnly = actionType != null && actionType.isReadOnly();
            AnySourceResponseService<?, ?> responseService = this.getResponseService(bc);
            if (CrudmaActionType.CREATE == actionType) {
                readOnly &= responseService.isDeferredCreationSupported(bc);
            }
        }
        return readOnly;
    }

    private AnySourceResponseService<?, ?> getResponseService(BusinessComponent bc) {
        return this.respFactory.getService((AnySourceBcDescription)bc.getDescription());
    }
}

