/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.controller;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.cxbox.core.file.controller.CxboxFileController;
import org.cxbox.core.file.dto.CxboxResponseDTO;
import org.cxbox.core.file.dto.FileDownloadDto;
import org.cxbox.core.file.dto.FileUploadDto;
import org.cxbox.core.file.service.CxboxFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"#{ (${cxbox.api.use-servlet-context-path} == true) ? '':  '${cxbox.api.path}'}/file"})
@ConditionalOnMissingBean(value={CxboxFileController.class})
public class CxboxFileControllerSimple
implements CxboxFileController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CxboxFileControllerSimple.class);
    private final CxboxFileService cxboxFileService;

    @PostMapping(consumes={"multipart/form-data"})
    public CxboxResponseDTO<FileUploadDto> upload(MultipartFile file, String source) {
        String id = this.cxboxFileService.upload(file, source);
        return new CxboxResponseDTO<FileUploadDto>().setData(new FileUploadDto(id, file.getOriginalFilename(), file.getContentType()));
    }

    @Override
    @GetMapping
    public HttpEntity<byte[]> download(String id, String source, boolean preview) {
        Object file = this.cxboxFileService.download(id, source);
        return this.buildFileHttpEntity(((FileDownloadDto)file).getBytes(), ((FileDownloadDto)file).getName(), ((FileDownloadDto)file).getType(), preview);
    }

    @Override
    @DeleteMapping
    public CxboxResponseDTO<Void> remove(String id, String source) {
        this.cxboxFileService.remove(id, source);
        return new CxboxResponseDTO<Void>();
    }

    @ConstructorProperties(value={"cxboxFileService"})
    @Generated
    public CxboxFileControllerSimple(CxboxFileService cxboxFileService) {
        this.cxboxFileService = cxboxFileService;
    }
}

