/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.DTOUtils;
import org.springframework.stereotype.Service;

@Service
public class DTOSecurityUtils {
    private final LoadingCache<Class<? extends DataResponseDTO>, Set<DtoField<DataResponseDTO, ?>>> dtoFieldsCache = CacheBuilder.newBuilder().build(new DtoFieldCacheLoader());

    public <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFields(Class<D> dtoClass) {
        return (Set)this.dtoFieldsCache.get(dtoClass);
    }

    private class DtoFieldCacheLoader<D extends DataResponseDTO>
    extends CacheLoader<Class<D>, Set<DtoField<D, ?>>> {
        private DtoFieldCacheLoader() {
        }

        public Set<DtoField<D, ?>> load(Class<D> dtoClass) {
            return DTOUtils.getAllFields(dtoClass);
        }
    }
}

