/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller.param.resolvers;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.cxbox.api.data.PageSpecification;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.util.tz.TimeZoneSpecification;
import org.cxbox.core.controller.param.resolvers.AbstractParameterArgumentResolver;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

public class TimeZoneParameterArgumentResolver
extends AbstractParameterArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return TimeZoneSpecification.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (!this.supportsParameter(parameter)) {
            return PageSpecification.DEFAULT;
        }
        return new TimeZoneSpecification(this.getTimezone(webRequest.getParameterMap()));
    }

    private LOV getTimezone(Map<String, ?> queryParametersMap) {
        String timezone = TimeZoneParameterArgumentResolver.getParameterValue(queryParametersMap.get("_timezone"));
        String tzOffset = TimeZoneParameterArgumentResolver.getParameterValue(queryParametersMap.get("_tzoffset"));
        if (StringUtils.isNotBlank((CharSequence)timezone)) {
            return new LOV(timezone);
        }
        if (tzOffset == null) {
            return null;
        }
        LinkedHashSet<String> zones = new LinkedHashSet<String>();
        DictionaryCache.dictionary().getAll((IDictionaryType)DictionaryType.TIMEZONE).forEach(dict -> zones.add(dict.getKey()));
        zones.addAll(ZoneId.getAvailableZoneIds());
        for (String zoneId : zones) {
            if (!this.isSuitableTZ(zoneId, NumberUtils.toInt((String)tzOffset, (int)Integer.MAX_VALUE))) continue;
            return new LOV(zoneId);
        }
        return null;
    }

    private boolean isSuitableTZ(String zoneId, Integer tzOffset) {
        ZoneOffset offset = ZoneId.of(zoneId).getRules().getOffset(Instant.now());
        return tzOffset.equals(offset.getTotalSeconds());
    }
}

