/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.tree.ExpressionNode;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.ast.AstDot;
import de.odysseus.el.tree.impl.ast.AstIdentifier;
import de.odysseus.el.util.SimpleContext;
import java.beans.ConstructorProperties;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JuelUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JuelUtils.class);

    public static Set<Property> getProperties(String template) {
        return JuelUtils.getProperties(new TreeStore((TreeBuilder)new Builder(), null).get(template).getRoot());
    }

    private static Set<Property> getProperties(ExpressionNode node) {
        HashSet<Property> result = new HashSet<Property>();
        if (node instanceof AstIdentifier) {
            result.add(new Property(node.toString(), Collections.emptyList()));
        } else if (node instanceof AstDot) {
            ArrayList<String> properties = new ArrayList<String>();
            ExpressionNode childNode = node;
            while (childNode instanceof AstDot) {
                properties.add(0, childNode.toString().replace(". ", ""));
                childNode = (ExpressionNode)childNode.getChild(0);
            }
            if (childNode instanceof AstIdentifier) {
                result.add(new Property(childNode.toString(), properties));
            } else {
                for (int i = 0; i < childNode.getCardinality(); ++i) {
                    result.addAll(JuelUtils.getProperties((ExpressionNode)childNode.getChild(i)));
                }
            }
        } else {
            for (int i = 0; i < node.getCardinality(); ++i) {
                result.addAll(JuelUtils.getProperties((ExpressionNode)node.getChild(i)));
            }
        }
        return result;
    }

    public static String format(String template, Map<String, Object> parameters) {
        SimpleContext context = new SimpleContext();
        context.setFunction("", "format", MethodUtils.getAccessibleMethod(JuelUtils.class, (String)"formatDate", (Class[])new Class[]{Object.class, String.class}));
        context.setFunction("", "urlEncode", MethodUtils.getAccessibleMethod(JuelUtils.class, (String)"encode", (Class[])new Class[]{Object.class}));
        context.setFunction("", "plusDays", MethodUtils.getAccessibleMethod(JuelUtils.class, (String)"plusDays", (Class[])new Class[]{LocalDateTime.class, Integer.class}));
        context.setFunction("", "plusMonth", MethodUtils.getAccessibleMethod(JuelUtils.class, (String)"plusMonth", (Class[])new Class[]{LocalDateTime.class, Integer.class}));
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        parameters.forEach((arg_0, arg_1) -> JuelUtils.lambda$format$0(context, (ExpressionFactory)factory, arg_0, arg_1));
        return (String)factory.createValueExpression((ELContext)context, (String)ObjectUtils.defaultIfNull((Object)template, (Object)""), String.class).getValue((ELContext)context);
    }

    public static String formatDate(Object date, String format) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format(date);
        }
        if (date instanceof LocalDate) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
            return ((LocalDate)date).format(dtf);
        }
        if (date instanceof LocalDateTime) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
            return ((LocalDateTime)date).format(dtf);
        }
        throw new IllegalArgumentException("JuelUtils#format: Expected Date, LocalDate or LocalDateTime. Found: " + date.getClass().getCanonicalName());
    }

    public static String encode(Object object) {
        return object == null ? null : URLEncoder.encode(object.toString(), "UTF-8");
    }

    public static LocalDateTime plusDays(LocalDateTime dateTime, Integer value) {
        return dateTime == null ? null : dateTime.plusDays(value.intValue());
    }

    public static LocalDateTime plusMonth(LocalDateTime dateTime, Integer value) {
        return dateTime == null ? null : dateTime.plusMonths(value.intValue());
    }

    @Generated
    private JuelUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static /* synthetic */ void lambda$format$0(SimpleContext context, ExpressionFactory factory, String k, Object v) {
        context.setVariable(k, factory.createValueExpression(v, v == null ? Object.class : v.getClass()));
    }

    public static class Property {
        private final String identifier;
        private final List<String> properties;

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public List<String> getProperties() {
            return this.properties;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$identifier = this.getIdentifier();
            String other$identifier = other.getIdentifier();
            if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
                return false;
            }
            List<String> this$properties = this.getProperties();
            List<String> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $identifier = this.getIdentifier();
            result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
            List<String> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JuelUtils.Property(identifier=" + this.getIdentifier() + ", properties=" + this.getProperties() + ")";
        }

        @ConstructorProperties(value={"identifier", "properties"})
        @Generated
        public Property(String identifier, List<String> properties) {
            this.identifier = identifier;
            this.properties = properties;
        }
    }
}

