/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.bc;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.service.ResponseFactory;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.stereotype.Service;

@Service
public class InnerBcTypeAware {
    private final Map<String, InnerBcTypes> types;

    public InnerBcTypeAware(BcRegistry bcRegistry, ResponseFactory respFactory) {
        this.types = bcRegistry.select(InnerBcDescription.class).collect(Collectors.toMap(BcDescription::getName, bcDescription -> new InnerBcTypes(respFactory.getResponseServiceParameters((InnerBcDescription)bcDescription))));
    }

    public Class<? extends BaseEntity> getTypeOfEntity(InnerBcDescription bcDescription) {
        return this.types.get(bcDescription.getName()).getEntity();
    }

    public Class<? extends DataResponseDTO> getTypeOfDto(InnerBcDescription bcDescription) {
        return this.types.get(bcDescription.getName()).getDto();
    }

    private static class InnerBcTypes {
        private final Class<? extends BaseEntity> entity;
        private final Class<? extends DataResponseDTO> dto;

        InnerBcTypes(Type[] responseServiceTypes) {
            this.entity = (Class)responseServiceTypes[1];
            this.dto = (Class)responseServiceTypes[0];
        }

        @Generated
        public Class<? extends BaseEntity> getEntity() {
            return this.entity;
        }

        @Generated
        public Class<? extends DataResponseDTO> getDto() {
            return this.dto;
        }
    }
}

