/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.config;

import org.cxbox.core.config.properties.UIProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.freemarker.FreeMarkerViewResolver;

@EnableConfigurationProperties(value={UIProperties.class})
@EnableWebMvc
public class UIConfig
implements WebMvcConfigurer {
    @Autowired
    private UIProperties uiProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.uiProperties.getUseServletContextPath().booleanValue()) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
        } else {
            registry.addResourceHandler(new String[]{this.uiProperties.getPath() + "/**"}).addResourceLocations(new String[]{"classpath:/ui/"});
        }
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        if (this.uiProperties.getUseServletContextPath().booleanValue()) {
            registry.addRedirectViewController("/ui", "/ui/");
            registry.addViewController("/").setViewName("index");
            registry.setOrder(Integer.MIN_VALUE);
        } else {
            registry.addRedirectViewController("/", this.uiProperties.getPath() + "/");
            registry.addRedirectViewController(this.uiProperties.getPath(), this.uiProperties.getPath() + "/");
            registry.addViewController(this.uiProperties.getPath() + "/").setViewName("index");
            registry.setOrder(Integer.MIN_VALUE);
        }
    }

    @Bean
    public FreeMarkerViewResolver freemarkerViewResolver() {
        FreeMarkerViewResolver resolver = new FreeMarkerViewResolver();
        resolver.setExposeSpringMacroHelpers(true);
        resolver.setExposeRequestAttributes(true);
        resolver.setCache(true);
        resolver.setCacheUnresolved(false);
        resolver.setSuffix(".ftl");
        resolver.setContentType("text/html;charset=UTF-8");
        return resolver;
    }
}

