/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.core.config.properties.APIProperties;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.bc.BcHierarchy;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UrlPathHelper;

@Service
public class BCFactory {
    private final APIProperties apiProperties;
    private final Set<String> operations = Set.of("data", "count", "custom-action", "associate", "row-meta-new", "row-meta-empty", "row-meta");
    private final BcRegistry bcRegistry;

    BcHierarchy getBcHierarchy(HttpServletRequest request) {
        Deque<String> bcList = this.getRequestParts(request);
        String operation = bcList.removeFirst();
        if (!this.operations.contains(operation)) {
            throw new IllegalArgumentException("Operation is not supported");
        }
        String screen = bcList.removeFirst();
        if (bcList.isEmpty()) {
            throw new IllegalArgumentException("URI must contain at least one BC");
        }
        if (bcList.getLast().equals("null")) {
            bcList.removeLast();
        }
        BcHierarchy bcHierarchy = null;
        while (!bcList.isEmpty()) {
            bcHierarchy = new BcHierarchy(screen, bcList.removeFirst(), bcList.isEmpty() ? null : bcList.removeFirst(), bcHierarchy);
        }
        return bcHierarchy;
    }

    private Deque<String> getRequestParts(HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (this.apiProperties.getUseServletContextPath().booleanValue()) {
            for (String prefix : new String[]{request.getContextPath(), request.getServletPath(), "/"}) {
                uri = StringUtils.removeStart((String)uri, (String)prefix);
            }
            return new LinkedList<String>(Arrays.asList(uri.split("/")));
        }
        uri = StringUtils.removeStart((String)new UrlPathHelper().getPathWithinApplication(request), (String)this.apiProperties.getPath());
        uri = StringUtils.removeStart((String)uri, (String)"/");
        return new LinkedList<String>(Arrays.asList(uri.split("/")));
    }

    BusinessComponent getBusinessComponent(HttpServletRequest request, QueryParameters queryParameters) {
        return this.getBusinessComponent(this.getBcHierarchy(request), queryParameters);
    }

    public BusinessComponent getBusinessComponent(BcHierarchy bcHierarchy, QueryParameters queryParameters) {
        return new BusinessComponent(Optional.of(bcHierarchy).map(BcHierarchy::getId).orElse(null), Optional.of(bcHierarchy).map(BcHierarchy::getParent).map(BcHierarchy::getId).orElse(null), this.bcRegistry.getBcDescription(bcHierarchy.getBcName()), bcHierarchy, queryParameters);
    }

    @ConstructorProperties(value={"apiProperties", "bcRegistry"})
    @Generated
    public BCFactory(APIProperties apiProperties, BcRegistry bcRegistry) {
        this.apiProperties = apiProperties;
        this.bcRegistry = bcRegistry;
    }
}

