/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.cxbox.api.exception.ServerException;
import org.cxbox.core.config.properties.APIProperties;
import org.cxbox.core.dto.ErrorResponseDTO;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.exception.BusinessIntermediateException;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.exception.UnconfirmedException;
import org.cxbox.core.exception.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Order(value=1)
@ControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Autowired
    private APIProperties apiProperties;

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorResponseDTO exception(Exception e) {
        UUID uuid = UUID.randomUUID();
        log.error(this.buildLogMessage(e, uuid), (Throwable)e);
        return new ErrorResponseDTO(this.buildResponseBody(e, uuid));
    }

    @ExceptionHandler(value={ClientException.class})
    public ResponseEntity<String> clientException(ClientException e) {
        UUID uuid = UUID.randomUUID();
        log.warn(this.buildLogMessage(e, uuid), (Throwable)e);
        return this.buildResponse(this.buildResponseBody(e, uuid), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.I_AM_A_TEAPOT)
    @ResponseBody
    public ErrorResponseDTO businessException(BusinessException e) {
        log.warn(e.getMessage(), (Throwable)e);
        return new ErrorResponseDTO(e);
    }

    @ExceptionHandler(value={BusinessIntermediateException.class})
    @ResponseStatus(value=HttpStatus.I_AM_A_TEAPOT)
    @ResponseBody
    public ErrorResponseDTO businessIntermediateException(Object data, BusinessIntermediateException e) {
        return new ErrorResponseDTO(e);
    }

    @ExceptionHandler(value={VersionMismatchException.class})
    @ResponseStatus(value=HttpStatus.CONFLICT)
    @ResponseBody
    public ErrorResponseDTO versionMismatchException(VersionMismatchException e) {
        return new ErrorResponseDTO(e);
    }

    @ExceptionHandler(value={UnconfirmedException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    @ResponseBody
    public ErrorResponseDTO unconfirmedException(UnconfirmedException e) {
        return new ErrorResponseDTO(e);
    }

    private ResponseEntity<String> buildResponse(String message, HttpStatus status) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.valueOf((String)"application/json;charset=UTF-8"));
        return new ResponseEntity((Object)message, (MultiValueMap)headers, (HttpStatusCode)status);
    }

    private String buildLogMessage(Exception ex, UUID uuid) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.apiProperties.isTrackExceptions()) {
            stringBuilder.append(uuid.toString()).append(": ");
        }
        stringBuilder.append(ex.getMessage());
        return stringBuilder.toString();
    }

    private String buildResponseBody(Exception ex, UUID uuid) {
        Throwable rootCause;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.apiProperties.isTrackExceptions()) {
            stringBuilder.append(uuid.toString()).append(": ");
        }
        Object message = ex instanceof ServerException ? ex.getMessage() : ((rootCause = ExceptionUtils.getRootCause((Throwable)ex)) == null ? ex.getClass().getSimpleName() + ": " + ex.getMessage() : rootCause.getMessage());
        stringBuilder.append((String)message);
        if (this.apiProperties.isFullStackTraces()) {
            stringBuilder.append("\n");
            stringBuilder.append(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        return stringBuilder.toString();
    }
}

