/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.bc;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.bc.BcHierarchy;
import org.cxbox.core.crudma.bc.impl.BcDescription;

public class BusinessComponent
implements BcIdentifier {
    private final String id;
    private final String parentId;
    private final BcDescription description;
    private BcHierarchy hierarchy;
    private QueryParameters parameters = QueryParameters.emptyQueryParameters();

    public BusinessComponent(String id, String parentId, BcDescription description) {
        this.id = this.normalizeNullValue(id);
        this.parentId = this.normalizeNullValue(parentId);
        this.description = Objects.requireNonNull(description);
    }

    public BusinessComponent(String id, String parentId, BcDescription description, BcHierarchy hierarchy) {
        this(id, parentId, description);
        this.hierarchy = hierarchy;
    }

    public BusinessComponent(String id, String parentId, BcDescription description, BcHierarchy hierarchy, QueryParameters parameters) {
        this(id, parentId, description, hierarchy);
        this.parameters = parameters;
    }

    public <T extends BcDescription> T getDescription() {
        return (T)this.description;
    }

    public Long getIdAsLong() {
        return this.getAsLong(this.id);
    }

    public Long getParentIdAsLong() {
        return this.getAsLong(this.parentId);
    }

    private Long getAsLong(String id) {
        return id == null ? null : Long.valueOf(id);
    }

    public String getName() {
        return this.description.getName();
    }

    public String getParentName() {
        return this.description.getParentName();
    }

    public List<String> getPreInvokeParameters() {
        return this.getParameters().getPreInvokeParameters();
    }

    public BusinessComponent withId(String id) {
        return new BusinessComponent(id, this.parentId, this.description, this.hierarchy == null ? null : this.hierarchy.withId(id), this.parameters);
    }

    public BusinessComponent withParentId(String parentId) {
        return new BusinessComponent(this.id, parentId, this.description, this.hierarchy == null ? null : this.hierarchy.withParentId(parentId), this.parameters);
    }

    private String normalizeNullValue(String value) {
        if (value == null || "null".equals(value)) {
            return null;
        }
        return value;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public BcHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Generated
    public QueryParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public String toString() {
        return "BusinessComponent(id=" + this.getId() + ", parentId=" + this.getParentId() + ", description=" + this.getDescription() + ", hierarchy=" + this.getHierarchy() + ", parameters=" + this.getParameters() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessComponent)) {
            return false;
        }
        BusinessComponent other = (BusinessComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        Object this$description = this.getDescription();
        Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        BcHierarchy this$hierarchy = this.getHierarchy();
        BcHierarchy other$hierarchy = other.getHierarchy();
        if (this$hierarchy == null ? other$hierarchy != null : !this$hierarchy.equals(other$hierarchy)) {
            return false;
        }
        QueryParameters this$parameters = this.getParameters();
        QueryParameters other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BusinessComponent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        Object $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        BcHierarchy $hierarchy = this.getHierarchy();
        result = result * 59 + ($hierarchy == null ? 43 : $hierarchy.hashCode());
        QueryParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
        return result;
    }

    @Generated
    public void setParameters(QueryParameters parameters) {
        this.parameters = parameters;
    }
}

