/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl.inner;

import java.util.List;
import java.util.Map;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dto.AssociateDTO;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.PreviewResult;
import org.cxbox.api.exception.ServerException;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.AnySourceBcDescription;
import org.cxbox.core.crudma.impl.AbstractCrudmaService;
import org.cxbox.core.dao.AnySourceBaseDAO;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.AssociateResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.AnySourceResponseFactory;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.action.ActionDescription;
import org.cxbox.core.service.rowmeta.AnySourceRowResponseService;
import org.cxbox.core.service.rowmeta.RowMetaType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AnySourceCrudmaService
extends AbstractCrudmaService {
    @Autowired
    private AnySourceResponseFactory respFactory;
    @Lazy
    @Autowired
    private AnySourceRowResponseService rowMeta;

    @Override
    public CreateResult create(BusinessComponent bc) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        this.availabilityCheck(responseService, ActionType.CREATE.getType(), bc);
        return responseService.createEntity(bc);
    }

    @Override
    public DataResponseDTO get(BusinessComponent bc) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        return responseService.getOne(bc);
    }

    @Override
    public ResultPage<? extends DataResponseDTO> getAll(BusinessComponent bc) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        return responseService.getList(bc);
    }

    @Override
    public PreviewResult preview(BusinessComponent bc, Map<String, Object> data) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService responseService = this.respFactory.getService(bcDescription);
        DataResponseDTO requestDto = this.respFactory.getDTOFromMapIgnoreBusinessErrors(data, this.respFactory.getDTOFromService(bcDescription), bc);
        Object responseDto = responseService.preview(bc, requestDto).getRecord();
        responseDto.setErrors(requestDto.getErrors());
        return new PreviewResult(requestDto, responseDto);
    }

    @Override
    public ActionResultDTO update(BusinessComponent bc, Map<String, Object> data) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService responseService = this.respFactory.getService(bcDescription);
        this.availabilityCheck(responseService, ActionType.SAVE.getType(), bc);
        DataResponseDTO requestDTO = this.respFactory.getDTOFromMap(data, this.respFactory.getDTOFromService(bcDescription), bc);
        responseService.validate(bc, requestDTO);
        AnySourceBaseDAO dao = responseService.getBaseDao();
        ActionResultDTO<Object> actionResultDTO = responseService.updateEntity(bc, requestDTO);
        dao.flush(bc);
        actionResultDTO.transformData(r -> responseService.entityToDto(bc, dao.getById(bc)));
        return actionResultDTO;
    }

    @Override
    public ActionResultDTO delete(BusinessComponent bc) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        this.availabilityCheck(responseService, ActionType.DELETE.getType(), bc);
        return responseService.deleteEntity(bc);
    }

    @Override
    public AssociateResultDTO associate(BusinessComponent bc, List<AssociateDTO> data) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        this.availabilityCheck(responseService, ActionType.ASSOCIATE.getType(), bc);
        return responseService.associate(data, bc);
    }

    @Override
    public ActionResultDTO invokeAction(BusinessComponent bc, String actionName, Map<String, Object> data) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService responseService = this.respFactory.getService(bcDescription);
        DataResponseDTO requestDTO = this.respFactory.getDTOFromMap(data, this.respFactory.getDTOFromService(bcDescription), bc);
        return responseService.invokeAction(bc, actionName, requestDTO);
    }

    @Override
    public MetaDTO getMetaNew(BusinessComponent bc, CreateResult createResult) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService<?, ?> responseService = this.getResponseService(bcDescription);
        return this.rowMeta.getAnySourceResponse(RowMetaType.META_NEW, createResult, bc, responseService);
    }

    @Override
    public MetaDTO getMeta(BusinessComponent bc) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService service = this.respFactory.getService(bcDescription);
        try {
            return this.rowMeta.getAnySourceResponse(RowMetaType.META, this.getDto(service, bc), bc, service);
        }
        catch (BusinessException e) {
            throw new BusinessException().addPopup(e.getMessage());
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MetaDTO getMetaEmpty(BusinessComponent bc) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService service = this.respFactory.getService(bcDescription);
        try {
            return this.rowMeta.getAnySourceResponse(RowMetaType.META_EMPTY, this.getDto(service, bc), bc, service);
        }
        catch (BusinessException e) {
            throw new BusinessException().addPopup(e.getMessage());
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public MetaDTO getOnFieldUpdateMeta(BusinessComponent bc, DataResponseDTO dto) {
        AnySourceBcDescription bcDescription = (AnySourceBcDescription)bc.getDescription();
        AnySourceResponseService service = this.respFactory.getService(bcDescription);
        return this.rowMeta.getAnySourceResponse(RowMetaType.ON_FIELD_UPDATE_META, dto, bc, service);
    }

    @Override
    public long count(BusinessComponent bc) {
        AnySourceResponseService<?, ?> responseService = this.getResponseService((AnySourceBcDescription)bc.getDescription());
        return responseService.count(bc);
    }

    private AnySourceResponseService<?, ?> getResponseService(AnySourceBcDescription anySourceBcDescription) {
        return this.respFactory.getService(anySourceBcDescription);
    }

    private DataResponseDTO getDto(AnySourceResponseService<?, ?> service, BusinessComponent bc) {
        if (bc.getId() != null && service.hasPersister()) {
            return service.getOne(bc);
        }
        Class dto = this.respFactory.getDTOFromService((AnySourceBcDescription)bc.getDescription());
        return (DataResponseDTO)dto.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void availabilityCheck(AnySourceResponseService<?, ?> service, String actionName, BusinessComponent bc) {
        ActionDescription<?> action = service.getActions().getAction(actionName);
        if (action == null || !action.isAvailable(bc)) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.action_unavailable", (Object[])new Object[]{actionName}));
        }
    }
}

