/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dao.impl;

import java.util.List;
import java.util.Map;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.cxbox.core.crudma.state.BcStateAware;
import org.cxbox.core.dao.AnySourceBaseDAO;
import org.cxbox.core.external.core.EntityFirstLevelCache;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAnySourceBaseDAO<E>
implements AnySourceBaseDAO<E> {
    @Autowired
    private EntityFirstLevelCache<E> cache;
    @Autowired
    private BcStateAware anySourceBcStateAware;

    @Override
    public String generateId() {
        return "-1";
    }

    @Override
    public long count(BusinessComponent bc) {
        Map<String, String> parameters = bc.getParameters().getParameters();
        parameters.put("_limit", "1");
        parameters.put("_page", "1");
        BusinessComponent countBc = new BusinessComponent(bc.getId(), bc.getParentId(), (BcDescription)bc.getDescription(), bc.getHierarchy(), new QueryParameters(parameters));
        return this.getList(countBc, countBc.getParameters()).getTotalElements();
    }

    @Override
    public E getById(BusinessComponent bc) {
        return (E)this.cache.getCache().computeIfAbsent(bc.getName(), bcName -> this.getByIdIgnoringFirstLevelCache(bc));
    }

    @Override
    public void setWithFirstLevelCache(BusinessComponent bc, E entity) {
        this.cache.getCache().put(bc.getName(), entity);
    }

    @Override
    public void flush(BusinessComponent bc) {
        if (this.anySourceBcStateAware.isPersisted(bc)) {
            this.setWithFirstLevelCache(bc, this.update(bc, this.getById(bc)));
        } else {
            this.setWithFirstLevelCache(bc, this.create(bc, this.getById(bc)));
        }
    }

    @Override
    public void associate(BusinessComponent bc, String parentId, List<String> childs) {
        throw new UnsupportedOperationException();
    }
}

