/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.cxbox.api.data.dto.rowmeta.ActionDTO;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.CxboxActionIconSpecifier;

public enum ActionType {
    CREATE("create", () -> LocalizationFormatter.uiMessage((String)"action.create"), CxboxActionIconSpecifier.PLUS, ActionAvailableChecker.NOT_NULL_PARENT_ID),
    CANCEL_CREATE("cancel-create", () -> LocalizationFormatter.uiMessage((String)"action.cancel-create"), CxboxActionIconSpecifier.CLOSE, ActionAvailableChecker.ALWAYS_TRUE),
    SAVE("save", () -> LocalizationFormatter.uiMessage((String)"action.save"), CxboxActionIconSpecifier.SAVE, ActionAvailableChecker.NOT_NULL_ID),
    COPY("copy", () -> LocalizationFormatter.uiMessage((String)"action.copy"), CxboxActionIconSpecifier.COPY, ActionAvailableChecker.NOT_NULL_ID),
    ASSOCIATE("associate", () -> LocalizationFormatter.uiMessage((String)"action.add"), CxboxActionIconSpecifier.PLUS, ActionAvailableChecker.NOT_NULL_PARENT_ID),
    DELETE("delete", () -> LocalizationFormatter.uiMessage((String)"action.delete"), CxboxActionIconSpecifier.DELETE, ActionAvailableChecker.NOT_NULL_ID);

    private final String type;
    private final Supplier<String> text;
    private final CxboxActionIconSpecifier icon;
    private final ActionAvailableChecker baseAvailableChecker;

    public boolean isTypeOf(ActionDTO action) {
        return action != null && Objects.equals(this.getType(), action.getType());
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Supplier<String> getText() {
        return this.text;
    }

    @Generated
    public CxboxActionIconSpecifier getIcon() {
        return this.icon;
    }

    @Generated
    public ActionAvailableChecker getBaseAvailableChecker() {
        return this.baseAvailableChecker;
    }

    @ConstructorProperties(value={"type", "text", "icon", "baseAvailableChecker"})
    @Generated
    private ActionType(String type, Supplier<String> text, CxboxActionIconSpecifier icon, ActionAvailableChecker baseAvailableChecker) {
        this.type = type;
        this.text = text;
        this.icon = icon;
        this.baseAvailableChecker = baseAvailableChecker;
    }
}

