/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.core.dto.MessageType;
import org.cxbox.core.service.action.DrillDownTypeSpecifier;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostAction {
    private final Map<String, String> attributes = new HashMap<String, String>();

    @JsonAnyGetter
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @JsonAnyGetter
    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Deprecated
    public String getType() {
        return this.attributes.get("type");
    }

    @Deprecated
    public String getBc() {
        return this.attributes.get("bc");
    }

    public PostAction add(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    public static PostAction refreshBc(BcIdentifier bcIdentifier) {
        return new PostAction().add("type", "refreshBC").add("bc", bcIdentifier.getName());
    }

    public static PostAction refreshParentBc(BcIdentifier bcIdentifier) {
        return new PostAction().add("type", "refreshBC").add("bc", bcIdentifier.getParentName());
    }

    public static PostAction downloadFile(String fileId) {
        return new PostAction().add("type", "downloadFile").add("fileId", fileId);
    }

    public static PostAction downloadFileByUrl(String url) {
        return new PostAction().add("type", "downloadFileByUrl").add("url", url);
    }

    public static PostAction openPickList(String pickList) {
        return new PostAction().add("type", "openPickList").add("pickList", pickList);
    }

    public static PostAction drillDown(DrillDownTypeSpecifier drillDownType, String url) {
        return PostAction.drillDown(drillDownType, url, null);
    }

    public static PostAction drillDown(DrillDownTypeSpecifier drillDownType, String url, String urlName) {
        return new PostAction().add("type", "drillDown").add("url", url).add("urlName", urlName).add("drillDownType", drillDownType.getValue());
    }

    public static PostAction delayedRefreshBC(BcIdentifier bcIdentifier, Number seconds) {
        return new PostAction().add("type", "delayedRefreshBC").add("bc", bcIdentifier.getName()).add("delay", seconds.toString());
    }

    public static PostAction showMessage(MessageType messageType, String messageText) {
        return new PostAction().add("type", "showMessage").add("messageType", messageType.getValue()).add("messageText", messageText);
    }

    public static PostAction postDelete() {
        return new PostAction().add("type", "postDelete");
    }

    public class BasePostActionField {
        public static final String TYPE = "type";
        public static final String BC = "bc";
        public static final String FILE_ID = "fileId";
        public static final String DELAY = "delay";
        public static final String MESSAGE_TYPE = "messageType";
        public static final String MESSAGE_TEXT = "messageText";
        public static final String URL = "url";
        public static final String URL_NAME = "urlName";
        public static final String DRILL_DOWN_TYPE = "drillDownType";
        public static final String PICK_LIST = "pickList";
    }

    public class BasePostActionType {
        public static final String REFRESH_BC = "refreshBC";
        public static final String DOWNLOAD_FILE = "downloadFile";
        public static final String DOWNLOAD_FILE_BY_URL = "downloadFileByUrl";
        public static final String OPEN_PICK_LIST = "openPickList";
        public static final String DRILL_DOWN = "drillDown";
        public static final String DELAYED_REFRESH_BC = "delayedRefreshBC";
        public static final String SHOW_MESSAGE = "showMessage";
        public static final String POST_DELETE = "postDelete";
    }
}

