/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.file.controller;

import java.nio.charset.StandardCharsets;
import org.cxbox.core.file.dto.CxboxResponseDTO;
import org.cxbox.core.file.dto.FileUploadDto;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public interface CxboxFileController {
    public CxboxResponseDTO<? extends FileUploadDto> upload(@RequestParam(value="file") MultipartFile var1, @RequestParam(value="source", required=false) String var2);

    public HttpEntity<byte[]> download(@RequestParam(value="id") String var1, @RequestParam(value="source", required=false) String var2, @RequestParam(value="preview", required=false, defaultValue="false") boolean var3);

    public CxboxResponseDTO<Void> remove(@RequestParam(value="id") String var1, @RequestParam(value="source") String var2);

    default public HttpEntity<byte[]> buildFileHttpEntity(byte[] content, String fileName, String fileType, boolean inline) {
        HttpHeaders header = new HttpHeaders();
        header.set("Content-Disposition", ContentDisposition.builder((String)(inline ? "inline" : "attachment")).filename(fileName, StandardCharsets.UTF_8).build().toString());
        header.setContentType(this.getMediaType(fileType));
        header.setContentLength((long)content.length);
        return new HttpEntity((Object)content, (MultiValueMap)header);
    }

    default public MediaType getMediaType(String type) {
        try {
            return MediaType.parseMediaType((String)type);
        }
        catch (InvalidMediaTypeException e) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }
}

