/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.cxbox.api.ExtendedDtoFieldLevelSecurityService;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.CrudmaActionHolder;
import org.cxbox.core.crudma.CrudmaActionType;
import org.cxbox.core.dto.mapper.AnySourceDtoConstructorService;
import org.cxbox.core.service.DTOSecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AnySourceDTOMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnySourceDTOMapper.class);
    private final AnySourceDtoConstructorService dtoConstructorService;
    private final Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService;
    private final DTOSecurityUtils dtoSecurityUtils;

    public <E, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, boolean flushRequired, Map<String, Object> attributes) {
        return this.entityToDto(entity, dtoClass, this.getDtoFieldsAvailableOnCurrentScreen(bc, dtoClass, true), flushRequired, attributes);
    }

    public <E, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, boolean flushRequired) {
        return this.entityToDto(entity, dtoClass, this.getDtoFieldsAvailableOnCurrentScreen(bc, dtoClass, true), flushRequired, Collections.emptyMap());
    }

    private <D extends DataResponseDTO> Set<DtoField<D, ?>> getDtoFieldsAvailableOnCurrentScreen(BcIdentifier bc, Class<D> dtoClass, boolean visibleOnly) {
        if (visibleOnly && this.extendedDtoFieldLevelSecurityService.isPresent()) {
            return this.extendedDtoFieldLevelSecurityService.get().getDtoFieldsAvailableOnCurrentScreen(bc);
        }
        return this.dtoSecurityUtils.getDtoFields(dtoClass);
    }

    public <E, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass) {
        return this.entityToDto(bc, entity, dtoClass, this.isFlushRequired(), Collections.emptyMap());
    }

    public <E, D extends DataResponseDTO> D entityToDto(BcIdentifier bc, E entity, Class<D> dtoClass, Map<String, Object> attributes) {
        return this.entityToDto(bc, entity, dtoClass, this.isFlushRequired(), attributes);
    }

    public <E, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass) {
        return this.entityToDto(entity, dtoClass, this.dtoSecurityUtils.getDtoFields(dtoClass), this.isFlushRequired(), Collections.emptyMap());
    }

    public <E, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields, boolean flushRequired) {
        return this.entityToDto(entity, dtoClass, fields, flushRequired, Collections.emptyMap());
    }

    public <E, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, DtoField<D, ?> field) {
        return this.entityToDto(entity, dtoClass, Collections.singleton(field));
    }

    public <E, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields) {
        return this.entityToDto(entity, dtoClass, fields, this.isFlushRequired());
    }

    private <E, D extends DataResponseDTO> D entityToDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> fields, boolean flushRequired, Map<String, Object> attributes) {
        if (flushRequired) {
            // empty if block
        }
        D result = this.createDto(entity, dtoClass, fields, attributes);
        this.setVstamp(result, entity);
        return result;
    }

    private <E, D extends DataResponseDTO> D createDto(E entity, Class<D> dtoClass, Set<DtoField<D, ?>> dtoFields, Map<String, Object> attributes) {
        return this.dtoConstructorService.create(entity, dtoClass, dtoFields, attributes);
    }

    private <E> void setVstamp(Object dto, E entity) {
        if (!(dto instanceof DataResponseDTO)) {
            return;
        }
        DataResponseDTO responseDTO = (DataResponseDTO)dto;
        responseDTO.setVstamp(0L);
    }

    private boolean isFlushRequired() {
        CrudmaActionType action = CrudmaActionHolder.getActionType();
        return action != null && action.isFlushRequired();
    }

    @ConstructorProperties(value={"dtoConstructorService", "extendedDtoFieldLevelSecurityService", "dtoSecurityUtils"})
    @Generated
    public AnySourceDTOMapper(AnySourceDtoConstructorService dtoConstructorService, Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService, DTOSecurityUtils dtoSecurityUtils) {
        this.dtoConstructorService = dtoConstructorService;
        this.extendedDtoFieldLevelSecurityService = extendedDtoFieldLevelSecurityService;
        this.dtoSecurityUtils = dtoSecurityUtils;
    }
}

