/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.action;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.ActionDTO;
import org.cxbox.api.data.dto.rowmeta.PreActionDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.ActionType;
import org.cxbox.core.dto.rowmeta.PreAction;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.ActionDescriptionBuilder;
import org.cxbox.core.service.action.ActionInvoker;
import org.cxbox.core.service.action.ActionScope;
import org.cxbox.core.service.action.DataValidator;
import org.cxbox.core.service.action.PreActionEvent;
import org.cxbox.core.service.action.PreActionEventSpecifier;
import org.cxbox.core.service.action.PreActionSpecifier;

public final class ActionDescription<T extends DataResponseDTO> {
    private final String key;
    private final String text;
    private final Map<String, String> customParameters;
    private final ActionAvailableChecker actionAvailableChecker;
    private final ActionInvoker<T> actionInvoker;
    private final PreActionSpecifier preActionSpecifier;
    private final PreActionEventSpecifier preActionEventSpecifier;
    private final DataValidator<T> dataValidator;
    private final String iconCode;
    private final boolean showOnlyIcon;
    private final ActionScope actionScope;
    private final boolean autoSaveBefore;

    public static <T extends DataResponseDTO> ActionDescriptionBuilder<T> builder() {
        return new ActionDescriptionBuilder();
    }

    public boolean isAvailable(BusinessComponent bc) {
        if (Arrays.stream(ActionType.values()).noneMatch(e -> e.getType().equals(this.key)) && ActionScope.RECORD.equals((Object)this.actionScope)) {
            return ActionAvailableChecker.and(ActionAvailableChecker.NOT_NULL_ID, this.actionAvailableChecker).isAvailable(bc);
        }
        return this.actionAvailableChecker.isAvailable(bc);
    }

    public boolean isUpdateRequired() {
        return this.actionInvoker.isUpdateRequired();
    }

    public ActionResultDTO<T> invoke(BusinessComponent bc, T data) {
        return this.actionInvoker.invoke(bc, data);
    }

    public PreAction withPreAction(BusinessComponent bc) {
        return this.preActionSpecifier.withPreAction(bc);
    }

    public List<PreActionEvent> withPreActionEvents(BusinessComponent bc) {
        return this.preActionEventSpecifier.withPreActionEvents(bc);
    }

    public List<String> validate(BusinessComponent bc, DataResponseDTO requestDTO, T data) {
        return this.dataValidator.validate(bc, requestDTO, data);
    }

    public ActionDTO toDto(BusinessComponent bc) {
        PreAction preAction = this.withPreAction(bc);
        return ActionDTO.builder().available(this.isAvailable(bc)).customParameters(this.getCustomParameters()).type(this.getKey()).text(this.getText()).icon(this.getIconCode()).showOnlyIcon(this.isShowOnlyIcon()).preActionDTO(Objects.nonNull(preAction) ? PreActionDTO.builder().type(preAction.getType()).message(preAction.getMessage(this.getKey())).customParameter(preAction.getCustomParameters()).build() : null).scope(this.getActionScope().toString().toLowerCase()).autoSaveBefore(this.isAutoSaveBefore()).build();
    }

    @ConstructorProperties(value={"key", "text", "customParameters", "actionAvailableChecker", "actionInvoker", "preActionSpecifier", "preActionEventSpecifier", "dataValidator", "iconCode", "showOnlyIcon", "actionScope", "autoSaveBefore"})
    @Generated
    public ActionDescription(String key, String text, Map<String, String> customParameters, ActionAvailableChecker actionAvailableChecker, ActionInvoker<T> actionInvoker, PreActionSpecifier preActionSpecifier, PreActionEventSpecifier preActionEventSpecifier, DataValidator<T> dataValidator, String iconCode, boolean showOnlyIcon, ActionScope actionScope, boolean autoSaveBefore) {
        this.key = key;
        this.text = text;
        this.customParameters = customParameters;
        this.actionAvailableChecker = actionAvailableChecker;
        this.actionInvoker = actionInvoker;
        this.preActionSpecifier = preActionSpecifier;
        this.preActionEventSpecifier = preActionEventSpecifier;
        this.dataValidator = dataValidator;
        this.iconCode = iconCode;
        this.showOnlyIcon = showOnlyIcon;
        this.actionScope = actionScope;
        this.autoSaveBefore = autoSaveBefore;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    @Generated
    public String getIconCode() {
        return this.iconCode;
    }

    @Generated
    public boolean isShowOnlyIcon() {
        return this.showOnlyIcon;
    }

    @Generated
    public ActionScope getActionScope() {
        return this.actionScope;
    }

    @Generated
    public boolean isAutoSaveBefore() {
        return this.autoSaveBefore;
    }
}

