/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.session.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.service.session.CoreSessionService;
import org.cxbox.api.service.session.CxboxUserDetailsInterface;
import org.cxbox.api.service.session.IUser;
import org.cxbox.core.util.session.SessionService;
import org.cxbox.core.util.session.WebHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="sessionService")
public class SessionServiceImpl
implements SessionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionServiceImpl.class);
    private final CoreSessionService coreSessionService;

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public IUser<Long> getSessionUser() {
        return this.coreSessionService.getSessionUserDetails(true);
    }

    @Override
    public Long getSessionUserDepartmentId() {
        return (Long)this.getSessionUser().getDepartmentId();
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, key="#root.methodName")
    public LOV getSessionUserRole() {
        CxboxUserDetailsInterface userDetails = this.coreSessionService.getSessionUserDetails(true);
        HttpServletRequest request = WebHelper.getCurrentRequest().orElse(null);
        if (request == null) {
            return userDetails.getUserRole();
        }
        return this.calculateUserRole(request, userDetails);
    }

    private LOV calculateUserRole(HttpServletRequest request, CxboxUserDetailsInterface userDetails) {
        LOV mainRole = userDetails.getUserRole();
        String requestedRole = request.getHeader("RequestedUserRole");
        if (StringUtils.isBlank((CharSequence)requestedRole)) {
            return mainRole;
        }
        if (mainRole != null && requestedRole.equals(mainRole.getKey())) {
            return mainRole;
        }
        return new LOV(requestedRole);
    }

    @Override
    public String getSessionId() {
        return this.coreSessionService.getSessionId();
    }

    @ConstructorProperties(value={"coreSessionService"})
    @Generated
    public SessionServiceImpl(CoreSessionService coreSessionService) {
        this.coreSessionService = coreSessionService;
    }
}

