/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.controller;

import jakarta.servlet.http.HttpServletRequest;
import org.cxbox.core.controller.BCFactory;
import org.cxbox.core.crudma.bc.BcHierarchy;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.BcDescription;
import org.springframework.stereotype.Service;
import org.springframework.web.context.annotation.RequestScope;

@Service
@RequestScope
public class BcHierarchyAware {
    private final BcHierarchy bcHierarchy;
    private final BcRegistry bcRegistry;

    public BcHierarchyAware(HttpServletRequest request, BCFactory bcFactory, BcRegistry bcRegistry) {
        this.bcHierarchy = this.getBcHierarchy(request, bcFactory);
        this.bcRegistry = bcRegistry;
    }

    private BcHierarchy getBcHierarchy(HttpServletRequest request, BCFactory bcFactory) {
        try {
            return bcFactory.getBcHierarchy(request);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasHierarchy() {
        return this.bcHierarchy != null;
    }

    @Deprecated
    public BcDescription getBcDescription() {
        if (this.bcHierarchy == null) {
            throw new IllegalStateException();
        }
        return this.bcRegistry.getBcDescription(this.bcHierarchy.getBcName());
    }

    @Deprecated
    public String getScreenName() {
        if (this.bcHierarchy == null) {
            throw new IllegalStateException();
        }
        return this.bcHierarchy.getScreenName();
    }
}

