/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.action;

import org.cxbox.core.crudma.bc.BusinessComponent;

@FunctionalInterface
public interface ActionAvailableChecker {
    public static final ActionAvailableChecker NOT_NULL_ID = bc -> bc.getId() != null;
    public static final ActionAvailableChecker NOT_NULL_PARENT_ID = bc -> bc.getParentName() == null || bc.getParentId() != null;
    public static final ActionAvailableChecker ALWAYS_TRUE = bc -> true;
    public static final ActionAvailableChecker ALWAYS_FALSE = bc -> false;

    public static ActionAvailableChecker and(ActionAvailableChecker ... checkers) {
        return new And(checkers);
    }

    public boolean isAvailable(BusinessComponent var1);

    public static class And
    implements ActionAvailableChecker {
        private final ActionAvailableChecker[] availableCheckers;

        public And(ActionAvailableChecker ... availableCheckers) {
            this.availableCheckers = availableCheckers;
        }

        @Override
        public boolean isAvailable(BusinessComponent bc) {
            for (ActionAvailableChecker availableChecker : this.availableCheckers) {
                if (availableChecker.isAvailable(bc)) continue;
                return false;
            }
            return true;
        }
    }
}

