/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.util.filter.provider.impl;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.dao.ClassifyDataParameter;
import org.cxbox.core.dto.multivalue.MultivalueField;
import org.cxbox.core.exception.ClientException;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.ClassifyDataProvider;
import org.cxbox.core.util.filter.provider.impl.AbstractClassifyDataProvider;
import org.springframework.stereotype.Component;

@Component
public class MultiFieldValueProvider
extends AbstractClassifyDataProvider
implements ClassifyDataProvider {
    @Override
    protected List<ClassifyDataParameter> getProviderParameterValues(Field dtoField, ClassifyDataParameter dataParameter, FilterParameter filterParam, SearchParameter searchParam, List<ClassifyDataProvider> providers) {
        String fieldName = dtoField.getDeclaredAnnotation(SearchParameter.class).name();
        Class<? extends ClassifyDataProvider> keyProvider = dtoField.getDeclaredAnnotation(SearchParameter.class).multiFieldKey();
        if (!fieldName.isEmpty() && (SearchOperation.CONTAINS_ONE_OF.equals((Object)dataParameter.getOperator()) || SearchOperation.EQUALS_ONE_OF.equals((Object)dataParameter.getOperator()))) {
            dataParameter.setField(fieldName);
            ClassifyDataProvider provider = providers.stream().filter(p -> p.getClass().equals(keyProvider)).findFirst().orElseThrow(() -> new ClientException(ErrorMessageSource.errorMessage((String)"error.data_provider_not_found")));
            provider.getClassifyDataParameters(dtoField, filterParam, searchParam, providers).stream().findFirst().ifPresent(classifyDataParameter -> dataParameter.setValue(classifyDataParameter.getValue()));
            return Collections.singletonList(dataParameter);
        }
        throw new ClientException(ErrorMessageSource.errorMessage((String)"error.unsupported_type_filtration", (Object[])new Object[]{MultivalueField.class}));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiFieldValueProvider)) {
            return false;
        }
        MultiFieldValueProvider other = (MultiFieldValueProvider)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MultiFieldValueProvider;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

