/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.crudma.impl;

import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractAnySourceResponseService;
import org.cxbox.core.dao.AnySourceBaseDAO;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.AnySourceVersionMismatchException;
import org.cxbox.core.service.rowmeta.AnySourceFieldMetaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnySourceVersionAwareResponseService<T extends DataResponseDTO, E>
extends AbstractAnySourceResponseService<T, E> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnySourceVersionAwareResponseService.class);

    protected AnySourceVersionAwareResponseService(Class<T> typeOfDTO, Class<E> typeOfEntity, Class<? extends AnySourceFieldMetaBuilder<T>> metaBuilder, Class<? extends AnySourceBaseDAO<E>> anySourceBaseDAOClass) {
        super(typeOfDTO, typeOfEntity, metaBuilder, anySourceBaseDAOClass);
    }

    public Long getVstamp(E entity) {
        return 0L;
    }

    public void setVstamp(String id, E entity) {
    }

    @Override
    public CreateResult<T> createEntity(BusinessComponent bc) {
        E entity = this.create(bc);
        if (this.getBaseDao().getId(entity) == null && bc.getId() != null) {
            this.getBaseDao().setId(bc.getId(), entity);
        }
        if (this.getBaseDao().getId(entity) == null) {
            this.getBaseDao().setId(this.getBaseDao().generateId(), entity);
        }
        CreateResult<T> createResult = this.doCreateEntity(entity, bc);
        this.getBaseDao().setWithFirstLevelCache(bc, entity);
        return createResult;
    }

    protected E create(BusinessComponent bc) {
        return (E)this.typeOfEntity.newInstance();
    }

    @Override
    public ActionResultDTO<T> updateEntity(BusinessComponent bc, DataResponseDTO data) {
        E entity = this.loadEntity(bc, data);
        ActionResultDTO<DataResponseDTO> resultDTO = this.doUpdateEntity(entity, (DataResponseDTO)this.typeOfDTO.cast(data), bc);
        this.getBaseDao().setWithFirstLevelCache(bc, entity);
        return resultDTO;
    }

    @Override
    public ActionResultDTO<T> preview(BusinessComponent bc, DataResponseDTO data) {
        return this.doPreview(this.loadEntity(bc, data), (DataResponseDTO)this.typeOfDTO.cast(data), bc);
    }

    @Override
    protected E loadEntity(BusinessComponent bc, DataResponseDTO data) {
        Object entity = this.isExist(bc);
        Long vstamp = this.getVstamp(entity);
        if (!Objects.equals(data.getVstamp(), -1L) && !Objects.equals(vstamp, data.getVstamp())) {
            throw new AnySourceVersionMismatchException(vstamp, data);
        }
        return entity;
    }

    protected abstract CreateResult<T> doCreateEntity(E var1, BusinessComponent var2);

    protected abstract ActionResultDTO<T> doUpdateEntity(E var1, T var2, BusinessComponent var3);

    protected ActionResultDTO<T> doPreview(E entity, T data, BusinessComponent bc) {
        return this.doUpdateEntity(entity, data, bc);
    }
}

