/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cxbox.api.ExtendedDtoFieldLevelSecurityService;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.config.properties.WidgetFieldsIdResolverProperties;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.dto.rowmeta.ActionsDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.EngineFieldsMeta;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.dto.rowmeta.RowMetaDTO;
import org.cxbox.core.service.AnySourceResponseService;
import org.cxbox.core.service.linkedlov.LinkedDictionaryService;
import org.cxbox.core.service.rowmeta.AnySourceFieldMetaBuilder;
import org.cxbox.core.service.rowmeta.BcDisabler;
import org.cxbox.core.service.rowmeta.RowMetaType;
import org.cxbox.core.service.rowmeta.RowResponseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class AnySourceRowResponseService
extends RowResponseService {
    @Autowired
    public ApplicationContext ctx;
    @Autowired
    public Optional<List<BcDisabler>> bcDisablersList;
    public final Map<String, List<BcDisabler>> bcDisablers = new HashMap<String, List<BcDisabler>>();

    @PostConstruct
    public void init() {
        this.bcDisablersList.ifPresent(disablers -> {
            for (BcDisabler bcDisabler : disablers) {
                for (BcIdentifier bcIdentifier : bcDisabler.getSupportedBc()) {
                    this.bcDisablers.computeIfAbsent(bcIdentifier.getName(), s -> new ArrayList()).add(bcDisabler);
                }
            }
        });
    }

    public AnySourceRowResponseService(ApplicationContext ctx, Optional<List<BcDisabler>> bcDisablers, Optional<LinkedDictionaryService> linkedDictionaryService, Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService, WidgetFieldsIdResolverProperties properties, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        super(ctx, bcDisablers, linkedDictionaryService, extendedDtoFieldLevelSecurityService, properties, objectMapper);
    }

    public MetaDTO getAnySourceResponse(RowMetaType type, DataResponseDTO dataDTO, BusinessComponent bc, AnySourceResponseService<?, ?> responseService) {
        ActionsDTO actionDTO = responseService.getAvailableActions(type, dataDTO, bc);
        return this.getAnySourceResponse(type, dataDTO, bc, actionDTO, responseService.getAnySourceFieldMetaBuilder());
    }

    public MetaDTO getAnySourceResponse(RowMetaType type, DataResponseDTO dataDTO, BusinessComponent bc, ActionsDTO actionDTO, Class<? extends AnySourceFieldMetaBuilder> fieldMetaBuilder) {
        EngineFieldsMeta fieldsNode = this.getMeta(bc, type, dataDTO, true);
        if (fieldMetaBuilder != null && type != RowMetaType.META_EMPTY) {
            AnySourceFieldMetaBuilder builder = (AnySourceFieldMetaBuilder)this.ctx.getBean(fieldMetaBuilder);
            builder.buildIndependentMeta(fieldsNode, bc);
            if (bc.getId() != null) {
                builder.buildRowDependentMeta(fieldsNode, bc);
            }
        }
        for (BcDisabler bcDisabler : this.bcDisablers.getOrDefault(bc.getName(), Collections.emptyList())) {
            if (!bcDisabler.isBcDisabled(bc)) continue;
            fieldsNode.disableFields();
            bcDisabler.disableActions(actionDTO);
        }
        return new MetaDTO(new RowMetaDTO(actionDTO, fieldsNode));
    }

    public MetaDTO getAnySourceResponse(RowMetaType type, CreateResult createResult, BusinessComponent bc, AnySourceResponseService<?, ?> responseService) {
        Object newRecord = createResult.getRecord();
        BusinessComponent newBc = bc.withId(newRecord.getId());
        MetaDTO metaDTO = this.getAnySourceResponse(type, (DataResponseDTO)newRecord, newBc, responseService);
        metaDTO.setPostActions(createResult.getPostActions());
        return metaDTO;
    }
}

