/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.service.rowmeta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.ExtendedDtoFieldLevelSecurityService;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.util.CxReflectionUtils;
import org.cxbox.core.config.properties.WidgetFieldsIdResolverProperties;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.dto.rowmeta.ActionsDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.dto.rowmeta.EngineFieldsMeta;
import org.cxbox.core.dto.rowmeta.MetaDTO;
import org.cxbox.core.dto.rowmeta.RowMetaDTO;
import org.cxbox.core.service.ResponseService;
import org.cxbox.core.service.linkedlov.LinkedDictionaryService;
import org.cxbox.core.service.rowmeta.BcDisabler;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.core.service.rowmeta.RowMetaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RowResponseService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RowResponseService.class);
    private final ApplicationContext ctx;
    private final LinkedDictionaryService linkedDictionaryService;
    private final Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService;
    private final Map<String, List<BcDisabler>> bcDisablers;
    private final ObjectMapper objectMapper;
    private final WidgetFieldsIdResolverProperties properties;

    public RowResponseService(ApplicationContext ctx, Optional<List<BcDisabler>> bcDisablers, Optional<LinkedDictionaryService> linkedDictionaryService, Optional<ExtendedDtoFieldLevelSecurityService> extendedDtoFieldLevelSecurityService, WidgetFieldsIdResolverProperties properties, @Qualifier(value="cxboxObjectMapper") ObjectMapper objectMapper) {
        this.ctx = ctx;
        this.linkedDictionaryService = linkedDictionaryService.orElse(null);
        this.extendedDtoFieldLevelSecurityService = extendedDtoFieldLevelSecurityService;
        this.bcDisablers = new HashMap<String, List<BcDisabler>>();
        this.objectMapper = objectMapper;
        this.properties = properties;
        bcDisablers.ifPresent(disablers -> {
            for (BcDisabler bcDisabler : disablers) {
                for (BcIdentifier bcIdentifier : bcDisabler.getSupportedBc()) {
                    this.bcDisablers.computeIfAbsent(bcIdentifier.getName(), s -> new ArrayList()).add(bcDisabler);
                }
            }
        });
    }

    public MetaDTO getResponse(RowMetaType type, DataResponseDTO dataDTO, BusinessComponent bc, ResponseService<?, ?> responseService) {
        ActionsDTO actionDTO = responseService.getAvailableActions(type, dataDTO, bc);
        return this.getResponse(type, dataDTO, bc, actionDTO, responseService.getFieldMetaBuilder());
    }

    public MetaDTO getResponse(RowMetaType type, CreateResult createResult, BusinessComponent bc, ResponseService<?, ?> responseService) {
        Object newRecord = createResult.getRecord();
        BusinessComponent newBc = bc.withId(newRecord.getId());
        MetaDTO metaDTO = this.getResponse(type, (DataResponseDTO)newRecord, newBc, responseService);
        metaDTO.setPostActions(createResult.getPostActions());
        return metaDTO;
    }

    public MetaDTO getResponse(RowMetaType type, DataResponseDTO dataDTO, BusinessComponent bc, ActionsDTO actionDTO, Class<? extends FieldMetaBuilder> fieldMetaBuilder) {
        EngineFieldsMeta fieldsNode = this.getMeta(bc, type, dataDTO, true);
        if (this.linkedDictionaryService != null) {
            this.linkedDictionaryService.fillRowMetaWithLinkedDictionaries(fieldsNode, bc, dataDTO, type == RowMetaType.META_EMPTY);
        }
        if (fieldMetaBuilder != null && type != RowMetaType.META_EMPTY) {
            FieldMetaBuilder builder = (FieldMetaBuilder)this.ctx.getBean(fieldMetaBuilder);
            builder.buildIndependentMeta(fieldsNode, bc);
            if (bc.getId() != null) {
                builder.buildRowDependentMeta(fieldsNode, bc);
            }
        }
        for (BcDisabler bcDisabler : this.bcDisablers.getOrDefault(bc.getName(), Collections.emptyList())) {
            if (!bcDisabler.isBcDisabled(bc)) continue;
            fieldsNode.disableFields();
            bcDisabler.disableActions(actionDTO);
        }
        return new MetaDTO(new RowMetaDTO(actionDTO, fieldsNode));
    }

    public MetaDTO getExtremeResponse(RowMetaType type, DataResponseDTO dataDTO, BusinessComponent bc, Class<? extends FieldMetaBuilder> fieldMetaBuilder, boolean visibleOnly) {
        EngineFieldsMeta fieldsNode = this.getMeta(bc, type, dataDTO, visibleOnly);
        if (fieldMetaBuilder != null) {
            FieldMetaBuilder builder = (FieldMetaBuilder)this.ctx.getBean(fieldMetaBuilder);
            builder.buildRowDependentMeta(fieldsNode, bc);
        }
        return new MetaDTO(new RowMetaDTO(new ActionsDTO(), fieldsNode));
    }

    public EngineFieldsMeta getMeta(BcIdentifier bc, RowMetaType type, DataResponseDTO dataDto, boolean visibleOnly) {
        EngineFieldsMeta fieldsNode = new EngineFieldsMeta(this.objectMapper);
        for (String dtoField : this.getFields(bc, dataDto, visibleOnly)) {
            FieldDTO fieldDTO;
            Field field = FieldUtils.getField(dataDto.getClass(), (String)dtoField, (boolean)true);
            if (field == null || (fieldDTO = this.getDTOFromField(type, field, dataDto)) == null) continue;
            fieldsNode.add(fieldDTO);
        }
        return fieldsNode;
    }

    private Set<String> getFields(BcIdentifier bc, DataResponseDTO dataDTO, boolean visibleOnly) {
        if (visibleOnly && this.extendedDtoFieldLevelSecurityService.isPresent()) {
            return this.extendedDtoFieldLevelSecurityService.get().getBcFieldsForCurrentScreen(bc);
        }
        return CxReflectionUtils.getAllNonSyntheticFieldsList(dataDTO.getClass()).stream().map(Field::getName).collect(Collectors.toSet());
    }

    private FieldDTO getDTOFromField(RowMetaType type, Field field, DataResponseDTO dataDTO) {
        field.setAccessible(true);
        if (field.getAnnotation(JsonIgnore.class) != null) {
            return null;
        }
        FieldDTO fieldDTO = new FieldDTO(field);
        fieldDTO.setSortable(Boolean.valueOf(this.properties.isSortEnabledDefault()));
        try {
            switch (type) {
                case META_NEW: 
                case ON_FIELD_UPDATE_META: 
                case META: {
                    fieldDTO.setCurrentValue(field.get(dataDTO));
                    break;
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return fieldDTO;
    }
}

