/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.core.dto.rowmeta;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.IDictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.data.dto.rowmeta.FieldDTO;
import org.cxbox.api.data.dto.rowmeta.IconCode;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldsMeta<T extends DataResponseDTO>
extends RowDependentFieldsMeta<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldsMeta.class);

    public FieldsMeta(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    public final void addConcreteFilterValue(DtoField<? super T, ?> field, SimpleDictionary dictDTO) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.addFilterValue(dictDTO));
    }

    @SafeVarargs
    public final void enableFilter(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setFilterable(Boolean.valueOf(true))));
    }

    public final void setAllFilterValuesByLovType(DtoField<? super T, ?> field, IDictionaryType type) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearFilterValues();
            fieldDTO.setFilterValues(DictionaryCache.dictionary().getAll(type));
        });
    }

    public final void setAllFilterValuesByLovType(DtoField<?, ?> field, @NonNull IDictionaryType type, @NonNull Comparator<SimpleDictionary> comparator) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearFilterValues();
            fieldDTO.setFilterValues(DictionaryCache.dictionary().getAll(type).stream().filter(Objects::nonNull).sorted(comparator).toList());
        });
    }

    public final void setConcreteFilterValues(DtoField<? super T, ?> field, Collection<SimpleDictionary> dictDtoList) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.clearFilterValues();
            fieldDTO.setFilterValues(dictDtoList);
        });
    }

    public <T extends DataResponseDTO, E extends Enum> void setEnumFilterValues(@NonNull FieldsMeta<T> fieldsMeta, @Nullable DtoField<? super T, E> field, E ... values) {
        if (fieldsMeta == null) {
            throw new NullPointerException("fieldsMeta is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (field != null) {
            fieldsMeta.setConcreteFilterValues(field, Arrays.stream(values).map(en -> new SimpleDictionary(en.name(), this.serialize((Enum<?>)en))).collect(Collectors.toList()));
        }
    }

    @SafeVarargs
    public final void setForceActive(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setForceActive(Boolean.valueOf(true))));
    }

    @SafeVarargs
    public final void setEphemeral(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setEphemeral(Boolean.valueOf(true))));
    }

    public final void setFilterValuesWithIcons(DtoField<? super T, ?> field, IDictionaryType type, Map<LOV, IconCode> valueIconMap) {
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setDictionaryName(type.getName());
            fieldDTO.clearValues();
            valueIconMap.forEach((key, value) -> fieldDTO.setIconWithValue(type.lookupValue(key), value, true));
        });
    }

    public final void setFileAccept(DtoField<? super T, ?> field, @NonNull List<String> accept) {
        if (accept == null) {
            throw new NullPointerException("accept is marked non-null but is null");
        }
        Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> {
            fieldDTO.setFileAccept(null);
            fieldDTO.setFileAccept(String.join((CharSequence)",", accept));
        });
    }

    @SafeVarargs
    public final void enableSort(DtoField<? super T, ?> ... fields) {
        Stream.of(fields).forEach(field -> Optional.ofNullable(field).map(dtoField -> (FieldDTO)this.fields.get(dtoField.getName())).ifPresent(fieldDTO -> fieldDTO.setSortable(Boolean.valueOf(true))));
    }
}

