/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.cache;

import java.util.List;
import java.util.stream.Collectors;
import org.cxbox.api.data.dictionary.DictionaryCacheLoader;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.dictionary.entity.DictionaryItem;
import org.cxbox.model.dictionary.entity.DictionaryItemTranslation;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemCacheLoader
implements DictionaryCacheLoader {
    private final JpaDao jpaDao;

    public DictionaryItemCacheLoader(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }

    public String getLoaderName() {
        return this.getClass().getSimpleName();
    }

    public List<SimpleDictionary> load() {
        return this.jpaDao.getList(DictionaryItemTranslation.class).stream().map(this::toDictionary).collect(Collectors.toList());
    }

    private SimpleDictionary toDictionary(DictionaryItemTranslation translation) {
        SimpleDictionary simpleDictionary = new SimpleDictionary();
        DictionaryItem dictionaryItem = translation.getPrimaryEntity();
        simpleDictionary.setType(dictionaryItem.getType());
        simpleDictionary.setKey(dictionaryItem.getKey());
        simpleDictionary.setValue(translation.getValue());
        simpleDictionary.setActive(dictionaryItem.isActive());
        simpleDictionary.setDescription(dictionaryItem.getDescription());
        simpleDictionary.setLanguage(translation.getLanguage());
        simpleDictionary.setDisplayOrder(dictionaryItem.getDisplayOrder());
        return simpleDictionary;
    }
}

