/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.services.data.impl;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.dictionary.entity.DictionaryItem;
import org.cxbox.model.dictionary.entity.DictionaryItem_;
import org.cxbox.model.dictionary.entity.DictionaryTypeDesc;
import org.cxbox.model.dictionary.entity.DictionaryTypeDesc_;
import org.cxbox.source.DictionaryServiceAssociation;
import org.cxbox.source.dto.DictionaryItemDTO;
import org.cxbox.source.dto.DictionaryItemDTO_;
import org.cxbox.source.services.data.DictionaryItemService;
import org.cxbox.source.services.meta.DictionaryItemsFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DictionaryItemsServiceImpl
extends VersionAwareResponseService<DictionaryItemDTO, DictionaryItem>
implements DictionaryItemService {
    @Autowired
    private DictionaryCache dictionaryCache;

    public DictionaryItemsServiceImpl() {
        super(DictionaryItemDTO.class, DictionaryItem.class, null, DictionaryItemsFieldMetaBuilder.class);
    }

    protected Specification<DictionaryItem> getParentSpecification(BusinessComponent bc) {
        if (DictionaryServiceAssociation.adminDictionaryItem.isBc((BcIdentifier)bc)) {
            return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(DictionaryItem_.dictionaryTypeId).get(DictionaryTypeDesc_.id), (Object)bc.getParentIdAsLong())});
        }
        return (Specification & Serializable)(root, cq, cb) -> cb.and(new Predicate[0]);
    }

    protected ActionResultDTO<DictionaryItemDTO> doUpdateEntity(DictionaryItem item, DictionaryItemDTO data, BusinessComponent bc) {
        DictionaryTypeDesc dictionaryTypeDesc = (DictionaryTypeDesc)this.baseDAO.findById(DictionaryTypeDesc.class, item.getDictionaryTypeId().getId());
        item.setType(dictionaryTypeDesc.getType());
        if (data.isFieldChanged(DictionaryItemDTO_.key)) {
            item.setKey(data.getKey());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.active)) {
            item.setActive(data.getActive().booleanValue());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.displayOrder)) {
            item.setDisplayOrder(data.getDisplayOrder());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.description)) {
            item.setDescription(data.getDescription());
        }
        if (data.isFieldChanged(DictionaryItemDTO_.additionFlg)) {
            item.setAdditionFlg(data.isAdditionFlg());
        }
        DictionaryItemDTO updatedDto = (DictionaryItemDTO)this.entityToDto(bc, (BaseEntity)item);
        return new ActionResultDTO((DataResponseDTO)updatedDto);
    }

    protected CreateResult<DictionaryItemDTO> doCreateEntity(DictionaryItem entity, BusinessComponent bc) {
        DictionaryTypeDesc dictionaryTypeDesc = (DictionaryTypeDesc)this.baseDAO.findById(DictionaryTypeDesc.class, bc.getParentIdAsLong());
        entity.setDictionaryTypeId(dictionaryTypeDesc);
        entity.setType(dictionaryTypeDesc.getType());
        return new CreateResult((DataResponseDTO)((DictionaryItemDTO)this.entityToDto(bc, (BaseEntity)((DictionaryItem)this.baseDAO.findById(DictionaryItem.class, (Long)this.baseDAO.save((Object)entity))))));
    }

    public Actions<DictionaryItemDTO> getActions() {
        return Actions.builder().create().add().save().add().delete().add().action("reload-cache", LocalizationFormatter.uiMessage((String)"action.clearCache")).invoker(this::actionReloadCache).add().build();
    }

    private ActionResultDTO<DictionaryItemDTO> actionReloadCache(BusinessComponent bc, DictionaryItemDTO data) {
        this.dictionaryCache.reload();
        return new ActionResultDTO();
    }

    @Override
    public List<DictionaryItemDTO> reloadCache() {
        this.dictionaryCache.reload();
        List entities = this.baseDAO.getList(DictionaryItem.class);
        return entities.stream().map(DictionaryItemDTO::new).collect(Collectors.toList());
    }
}

