/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.dictionary.hibernate;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.cxbox.dictionary.Dictionary;
import org.cxbox.dictionary.hibernate.ImmutableType;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaXMember;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;
import org.hibernate.usertype.DynamicParameterizedType;

public class DictionaryType
extends ImmutableType<Dictionary>
implements DynamicParameterizedType {
    private Class<? extends Dictionary> elementType;

    public DictionaryType(Class<? extends Dictionary> elementType) {
        super(Dictionary.class);
        this.elementType = elementType;
    }

    public DictionaryType() {
        super(Dictionary.class);
    }

    public DictionaryType(TypeBootstrapContext typeBootstrapContext) {
        super(Dictionary.class, typeBootstrapContext);
    }

    public int getSqlType() {
        return 12;
    }

    @Override
    public Dictionary get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String key = rs.getString(position);
        return this.fromStringValue(key);
    }

    @Override
    public void set(PreparedStatement st, Dictionary value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, this.getSqlType());
        } else {
            st.setString(index, value.key());
        }
    }

    public Dictionary fromStringValue(CharSequence key) throws HibernateException {
        if (key == null) {
            return null;
        }
        Class<? extends Dictionary> iDictClass = this.elementType;
        if (iDictClass == null) {
            throw new IllegalStateException("class MUST extend IDict, but was null");
        }
        return Dictionary.of(iDictClass, (String)key.toString());
    }

    public void setParameterValues(Properties properties) {
        XProperty xProperty = (XProperty)properties.get("org.hibernate.type.ParameterType.xproperty");
        Type type = xProperty instanceof JavaXMember ? ((JavaXMember)xProperty).getJavaType() : ((DynamicParameterizedType.ParameterType)properties.get("org.hibernate.type.ParameterType")).getReturnedClass();
        this.elementType = (Class)type;
    }
}

