/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.dictionary.hibernate;

import java.util.ServiceLoader;
import org.cxbox.dictionary.DictionaryClassProvider;
import org.cxbox.dictionary.hibernate.DictionaryType;
import org.hibernate.HibernateException;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.usertype.UserType;

public class HibernateTypesContributor
implements TypeContributor {
    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        ConfigurationService configurationService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Boolean enableTypesContributor = (Boolean)configurationService.getSetting("org.cxbox.dictionary.enable_types_contributor", value -> {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                return Boolean.parseBoolean(stringValue);
            }
            throw new HibernateException(String.format("The value [%s] of the [%s] setting is not supported!", value, "org.cxbox.dictionary.enable_types_contributor"));
        });
        if (Boolean.FALSE.equals(enableTypesContributor)) {
            return;
        }
        ServiceLoader<DictionaryClassProvider> serviceLoader = ServiceLoader.load(DictionaryClassProvider.class);
        for (DictionaryClassProvider provider : serviceLoader) {
            try {
                Class dictClass = provider.getDictionaryType();
                typeContributions.contributeType((UserType)new DictionaryType(dictClass), new String[]{dictClass.getName()});
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }
}

