/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.service.data.impl;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.api.util.i18n.ErrorMessageSource;
import org.cxbox.api.util.i18n.LocalizationFormatter;
import org.cxbox.core.bc.InnerBcTypeAware;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.exception.BusinessException;
import org.cxbox.core.service.ResponseService;
import org.cxbox.core.service.action.ActionAvailableChecker;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.dictionary.links.entity.CustomizableResponseService;
import org.cxbox.model.dictionary.links.entity.CustomizableResponseService_;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule_;
import org.cxbox.source.dto.CustomizableResponseServiceDto;
import org.cxbox.source.dto.CustomizableResponseServiceDto_;
import org.cxbox.source.engine.LinkedDictionaryServiceImpl;
import org.cxbox.source.service.data.CustomizableResponseSrvsService;
import org.cxbox.source.service.meta.CustomizableResponseServiceFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CustomizableRespSrvsServiceImpl
extends VersionAwareResponseService<CustomizableResponseServiceDto, CustomizableResponseService>
implements CustomizableResponseSrvsService {
    @Autowired
    private LinkedDictionaryServiceImpl.LinkedDictionaryCache linkedDictionaryCache;
    @Autowired
    private BcRegistry bcRegistry;
    @Autowired
    private InnerBcTypeAware innerBcTypeAware;

    public CustomizableRespSrvsServiceImpl() {
        super(CustomizableResponseServiceDto.class, CustomizableResponseService.class, null, CustomizableResponseServiceFieldMetaBuilder.class);
    }

    public ActionResultDTO<CustomizableResponseServiceDto> deleteEntity(BusinessComponent bc) {
        Long rulesCount;
        if (bc.getIdAsLong() != null && (rulesCount = this.baseDAO.getCount(DictionaryLnkRule.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(DictionaryLnkRule_.service).get(CustomizableResponseService_.id), (Object)bc.getIdAsLong()))) > 0L) {
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.cant_delete_service_rules_exist"));
        }
        return super.deleteEntity(bc);
    }

    public Actions<CustomizableResponseServiceDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().action("clearCache", LocalizationFormatter.uiMessage((String)"action.clearCache")).available(ActionAvailableChecker.ALWAYS_TRUE).invoker((bc, data) -> {
            this.linkedDictionaryCache.evictRules();
            return new ActionResultDTO();
        }).add().build();
    }

    protected CreateResult<CustomizableResponseServiceDto> doCreateEntity(CustomizableResponseService entity, BusinessComponent bc) {
        this.baseDAO.save((Object)entity);
        return new CreateResult((DataResponseDTO)((CustomizableResponseServiceDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected ActionResultDTO<CustomizableResponseServiceDto> doUpdateEntity(CustomizableResponseService entity, CustomizableResponseServiceDto data, BusinessComponent bc) {
        if (data.isFieldChanged(CustomizableResponseServiceDto_.serviceName)) {
            if (!entity.getRules().isEmpty()) {
                throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.cant_modify_service_rules_exist"));
            }
            entity.setServiceName(data.getServiceName());
            InnerBcDescription bcDescription = this.bcRegistry.select(InnerBcDescription.class).distinct().filter(innerBc -> innerBc != null && innerBc.getServiceClass().getSimpleName().equals(data.getServiceName())).findFirst().orElse(null);
            if (bcDescription != null && ResponseService.class.isAssignableFrom(bcDescription.getServiceClass())) {
                entity.setDtoClass(this.innerBcTypeAware.getTypeOfDto(bcDescription).getName());
            }
        }
        return new ActionResultDTO((DataResponseDTO)((CustomizableResponseServiceDto)this.entityToDto(bc, (BaseEntity)entity)));
    }
}

