/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.service.data.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cxbox.api.data.ResultPage;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.core.controller.param.FilterParameter;
import org.cxbox.core.controller.param.FilterParameters;
import org.cxbox.core.controller.param.QueryParameters;
import org.cxbox.core.controller.param.SearchOperation;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractResponseService;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleValue;
import org.cxbox.source.dto.DictionaryLnkRuleValueDto;
import org.cxbox.source.service.data.DictionaryLnkRuleValueAssocService;
import org.cxbox.source.service.meta.DictionaryLnkRuleValueFieldMetaBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryLnkRuleValueAssocServiceImpl
extends AbstractResponseService<DictionaryLnkRuleValueDto, DictionaryLnkRuleValue>
implements DictionaryLnkRuleValueAssocService {
    @Autowired
    private DictionaryCache dictionaryCache;

    public DictionaryLnkRuleValueAssocServiceImpl() {
        super(DictionaryLnkRuleValueDto.class, DictionaryLnkRuleValue.class, null, DictionaryLnkRuleValueFieldMetaBuilder.class);
    }

    public ResultPage<DictionaryLnkRuleValueDto> getList(BusinessComponent bc) {
        QueryParameters params = bc.getParameters();
        DictionaryLnkRule parent = (DictionaryLnkRule)this.baseDAO.findById(DictionaryLnkRule.class, bc.getParentIdAsLong());
        List result = this.dictionaryCache.getAll(parent.getType()).stream().map(dictDTO -> {
            DictionaryLnkRuleValueDto dto = new DictionaryLnkRuleValueDto();
            dto.setId(dictDTO.getKey());
            dto.setValueCd(dictDTO.getKey());
            dto.setValue(dictDTO.getValue());
            return dto;
        }).filter(dto -> this.filterByQueryParams((DictionaryLnkRuleValueDto)((Object)dto), params.getFilter())).skip((long)params.getPageNumber() * (long)params.getPageSize()).limit((long)params.getPageSize() + 1L).collect(Collectors.toList());
        return this.dtoListToResultPage(result, params.getPageSize());
    }

    private boolean filterByQueryParams(DictionaryLnkRuleValueDto dto, FilterParameters searchParameters) {
        String dtoValue = dto.getValue().toLowerCase();
        String dtoValueCd = dto.getValueCd().toLowerCase();
        for (FilterParameter parameter : searchParameters) {
            if (Objects.isNull(parameter.getStringValue())) {
                return true;
            }
            String value = parameter.getStringValue().toLowerCase();
            SearchOperation operation = parameter.getOperation();
            String fieldName = parameter.getName();
            if (operation == SearchOperation.EQUALS) {
                if ("value".equals(fieldName)) {
                    return Objects.equals(value, dtoValue);
                }
                if ("valueCd".equals(fieldName)) {
                    return Objects.equals(value, dtoValueCd);
                }
            }
            if (operation != SearchOperation.CONTAINS) continue;
            if ("value".equals(fieldName)) {
                return dtoValue.contains(value);
            }
            if (!"valueCd".equals(fieldName)) continue;
            return dtoValueCd.contains(value);
        }
        return true;
    }

    public long count(BusinessComponent bc) {
        DictionaryLnkRule parent = (DictionaryLnkRule)this.baseDAO.findById(DictionaryLnkRule.class, bc.getParentIdAsLong());
        return this.dictionaryCache.getAll(parent.getType()).size();
    }
}

