/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.dto;

import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.dto.Lov;
import org.cxbox.core.util.filter.SearchParameter;
import org.cxbox.core.util.filter.provider.impl.LovValueProvider;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;

public class DictionaryLnkRuleCondDto
extends DataResponseDTO {
    @SearchParameter(provider=LovValueProvider.class)
    @Lov(value=DictionaryType.DICTIONARY_TERM_TYPE)
    private String type;
    private String typeCd;
    private String fieldName;
    @SearchParameter(name="fieldName")
    private String fieldNameText;
    private String fieldTextValue;
    private Boolean fieldBooleanValue;
    private String fieldDictValue;
    private String departmentId;
    private String bcName;
    private String fieldType;
    private boolean defaultRuleFlg;
    private boolean ruleInversionFlg;

    public DictionaryLnkRuleCondDto(DictionaryLnkRuleCond entity) {
        this.id = entity.getId().toString();
        this.fieldName = entity.getFieldName();
        this.fieldNameText = entity.getFieldName();
        this.bcName = entity.getBcName();
        this.departmentId = Optional.of(entity).map(DictionaryLnkRuleCond::getDepartmentId).map(Object::toString).orElse(null);
        this.fieldTextValue = entity.getFieldTextValue();
        this.fieldBooleanValue = entity.getFieldBooleanValue();
        this.type = DictionaryType.DICTIONARY_TERM_TYPE.lookupValue(entity.getType());
        this.typeCd = Optional.of(entity).map(DictionaryLnkRuleCond::getType).map(LOV::getKey).orElse(null);
        this.fieldType = entity.getFieldType();
        if (entity.getFieldType() != null) {
            this.fieldDictValue = DictionaryCache.dictionary().lookupValue(entity.getFieldDictValue(), entity.getFieldType());
        }
        if (entity.getDictionaryLnkRule() != null) {
            this.defaultRuleFlg = entity.getDictionaryLnkRule().getDefaultRuleFlg();
        }
        this.ruleInversionFlg = entity.getRuleInversionFlg();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getTypeCd() {
        return this.typeCd;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @Generated
    public String getFieldNameText() {
        return this.fieldNameText;
    }

    @Generated
    public String getFieldTextValue() {
        return this.fieldTextValue;
    }

    @Generated
    public Boolean getFieldBooleanValue() {
        return this.fieldBooleanValue;
    }

    @Generated
    public String getFieldDictValue() {
        return this.fieldDictValue;
    }

    @Generated
    public String getDepartmentId() {
        return this.departmentId;
    }

    @Generated
    public String getBcName() {
        return this.bcName;
    }

    @Generated
    public String getFieldType() {
        return this.fieldType;
    }

    @Generated
    public boolean isDefaultRuleFlg() {
        return this.defaultRuleFlg;
    }

    @Generated
    public boolean isRuleInversionFlg() {
        return this.ruleInversionFlg;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setTypeCd(String typeCd) {
        this.typeCd = typeCd;
    }

    @Generated
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Generated
    public void setFieldNameText(String fieldNameText) {
        this.fieldNameText = fieldNameText;
    }

    @Generated
    public void setFieldTextValue(String fieldTextValue) {
        this.fieldTextValue = fieldTextValue;
    }

    @Generated
    public void setFieldBooleanValue(Boolean fieldBooleanValue) {
        this.fieldBooleanValue = fieldBooleanValue;
    }

    @Generated
    public void setFieldDictValue(String fieldDictValue) {
        this.fieldDictValue = fieldDictValue;
    }

    @Generated
    public void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    @Generated
    public void setBcName(String bcName) {
        this.bcName = bcName;
    }

    @Generated
    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    @Generated
    public void setDefaultRuleFlg(boolean defaultRuleFlg) {
        this.defaultRuleFlg = defaultRuleFlg;
    }

    @Generated
    public void setRuleInversionFlg(boolean ruleInversionFlg) {
        this.ruleInversionFlg = ruleInversionFlg;
    }

    @Generated
    public DictionaryLnkRuleCondDto() {
    }

    @ConstructorProperties(value={"type", "typeCd", "fieldName", "fieldNameText", "fieldTextValue", "fieldBooleanValue", "fieldDictValue", "departmentId", "bcName", "fieldType", "defaultRuleFlg", "ruleInversionFlg"})
    @Generated
    public DictionaryLnkRuleCondDto(String type, String typeCd, String fieldName, String fieldNameText, String fieldTextValue, Boolean fieldBooleanValue, String fieldDictValue, String departmentId, String bcName, String fieldType, boolean defaultRuleFlg, boolean ruleInversionFlg) {
        this.type = type;
        this.typeCd = typeCd;
        this.fieldName = fieldName;
        this.fieldNameText = fieldNameText;
        this.fieldTextValue = fieldTextValue;
        this.fieldBooleanValue = fieldBooleanValue;
        this.fieldDictValue = fieldDictValue;
        this.departmentId = departmentId;
        this.bcName = bcName;
        this.fieldType = fieldType;
        this.defaultRuleFlg = defaultRuleFlg;
        this.ruleInversionFlg = ruleInversionFlg;
    }
}

