/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.service.data.impl;

import jakarta.persistence.metamodel.SingularAttribute;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.DictionaryType;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.VersionAwareResponseService;
import org.cxbox.core.dto.DTOUtils;
import org.cxbox.core.dto.rowmeta.ActionResultDTO;
import org.cxbox.core.dto.rowmeta.CreateResult;
import org.cxbox.core.service.action.Actions;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.source.dto.DictionaryLnkRuleCondDto;
import org.cxbox.source.dto.DictionaryLnkRuleCondDto_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseDictionaryLnkRuleCondServiceImpl<D extends DictionaryLnkRuleCondDto, E extends DictionaryLnkRuleCond>
extends VersionAwareResponseService<D, E> {
    @Autowired
    private DictionaryCache dictionaryCache;

    public BaseDictionaryLnkRuleCondServiceImpl(Class<D> typeOfDTO, Class<E> typeOfEntity, SingularAttribute<? super E, ? extends BaseEntity> parentSpec, Class<? extends FieldMetaBuilder<D>> metaBuilder) {
        super(typeOfDTO, typeOfEntity, parentSpec, metaBuilder);
    }

    protected CreateResult<D> doCreateEntity(E entity, BusinessComponent bc) {
        entity.setDictionaryLnkRule((DictionaryLnkRule)this.baseDAO.findById(DictionaryLnkRule.class, bc.getParentIdAsLong()));
        this.baseDAO.save(entity);
        return new CreateResult((DataResponseDTO)((DictionaryLnkRuleCondDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    protected final ActionResultDTO<D> doUpdateEntity(E entity, D data, BusinessComponent bc) {
        boolean isSqlService = "SqlCrudmaService".equals(entity.getDictionaryLnkRule().getService().getServiceName());
        if (data.hasChangedFields()) {
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.type)) {
                entity.setType(DictionaryType.DICTIONARY_TERM_TYPE.lookupName(((DictionaryLnkRuleCondDto)((Object)data)).getType()));
                entity.setFieldName(null);
                entity.setDepartmentId(null);
                entity.setFieldTextValue(null);
                entity.setBcName(null);
                entity.setFieldDictValue(null);
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.ruleInversionFlg)) {
                entity.setRuleInversionFlg(Boolean.valueOf(((DictionaryLnkRuleCondDto)((Object)data)).isRuleInversionFlg()));
            }
        }
        return this.doUpdateEntity(entity, data, isSqlService, bc);
    }

    protected ActionResultDTO<D> doUpdateEntity(E entity, D data, boolean isSqlService, BusinessComponent bc) {
        if (data.hasChangedFields()) {
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.fieldName)) {
                entity.setFieldName(((DictionaryLnkRuleCondDto)((Object)data)).getFieldName());
                Class<?> dtoClass = Class.forName(entity.getDictionaryLnkRule().getService().getDtoClass());
                if (CoreDictionaries.DictionaryTermType.DICTIONARY_FIELD.equals((Object)entity.getType()) && !isSqlService) {
                    entity.setFieldType(DTOUtils.getDictionaryType(dtoClass, (String)((DictionaryLnkRuleCondDto)((Object)data)).getFieldName()));
                }
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.bcName)) {
                entity.setBcName(((DictionaryLnkRuleCondDto)((Object)data)).getBcName());
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.departmentId)) {
                entity.setDepartmentId(Long.valueOf(((DictionaryLnkRuleCondDto)((Object)data)).getDepartmentId()));
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.fieldTextValue)) {
                entity.setFieldTextValue(((DictionaryLnkRuleCondDto)((Object)data)).getFieldTextValue());
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.fieldDictValue)) {
                entity.setFieldDictValue(entity.getFieldType() == null ? null : this.dictionaryCache.lookupName(((DictionaryLnkRuleCondDto)((Object)data)).getFieldDictValue(), entity.getFieldType()));
            }
            if (data.isFieldChanged(DictionaryLnkRuleCondDto_.fieldType) && isSqlService) {
                entity.setFieldType(((DictionaryLnkRuleCondDto)((Object)data)).getFieldType());
                entity.setFieldDictValue(null);
            }
        }
        return new ActionResultDTO((DataResponseDTO)((DictionaryLnkRuleCondDto)this.entityToDto(bc, (BaseEntity)entity)));
    }

    public Actions<D> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

