/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.service.meta;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BcRegistry;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.rowmeta.FieldsMeta;
import org.cxbox.core.dto.rowmeta.RowDependentFieldsMeta;
import org.cxbox.core.service.rowmeta.FieldMetaBuilder;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.dictionary.links.entity.CustomizableResponseService;
import org.cxbox.source.dto.CustomizableResponseServiceDto;
import org.cxbox.source.dto.CustomizableResponseServiceDto_;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomizableResponseServiceFieldMetaBuilder
extends FieldMetaBuilder<CustomizableResponseServiceDto> {
    @Autowired
    private JpaDao jpaDao;
    @Autowired
    private BcRegistry bcRegistry;

    public void buildRowDependentMeta(RowDependentFieldsMeta<CustomizableResponseServiceDto> fields, InnerBcDescription bcDescription, Long id, Long parentId) {
        fields.setEnabled(new DtoField[]{CustomizableResponseServiceDto_.serviceName});
        List alreadyCustomizableServices = this.jpaDao.getList(CustomizableResponseService.class).stream().map(CustomizableResponseService::getServiceName).filter(Objects::nonNull).collect(Collectors.toList());
        String[] notCustomizable = (String[])this.bcRegistry.select(InnerBcDescription.class).map(InnerBcDescription::getServiceClass).distinct().map(Class::getSimpleName).filter(service -> !alreadyCustomizableServices.contains(service)).toArray(String[]::new);
        fields.setDictionaryTypeWithCustomValues(CustomizableResponseServiceDto_.serviceName, notCustomizable);
    }

    public void buildIndependentMeta(FieldsMeta<CustomizableResponseServiceDto> fields, InnerBcDescription bcDescription, Long parentId) {
        fields.enableFilter(new DtoField[]{CustomizableResponseServiceDto_.serviceName});
        List filterServices = this.bcRegistry.select(InnerBcDescription.class).map(InnerBcDescription::getServiceClass).distinct().map(Class::getSimpleName).map(className -> new SimpleDictionary(className, className)).collect(Collectors.toList());
        fields.setConcreteFilterValues(CustomizableResponseServiceDto_.serviceName, filterServices);
    }
}

