/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.service.data.impl;

import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.cxbox.api.data.BcIdentifier;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dto.AssociateDTO;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.impl.AbstractResponseService;
import org.cxbox.core.dto.rowmeta.AssociateResultDTO;
import org.cxbox.core.dto.rowmeta.PostAction;
import org.cxbox.core.service.action.Actions;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleValue;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleValue_;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule_;
import org.cxbox.source.dto.DictionaryLnkRuleValueDto;
import org.cxbox.source.service.data.DictionaryLnkRuleValueService;
import org.cxbox.source.service.meta.DictionaryLnkRuleValueFieldMetaBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class DictionaryLnkRuleValueServiceImpl
extends AbstractResponseService<DictionaryLnkRuleValueDto, DictionaryLnkRuleValue>
implements DictionaryLnkRuleValueService {
    public DictionaryLnkRuleValueServiceImpl() {
        super(DictionaryLnkRuleValueDto.class, DictionaryLnkRuleValue.class, null, DictionaryLnkRuleValueFieldMetaBuilder.class);
    }

    protected Specification<DictionaryLnkRuleValue> getSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(DictionaryLnkRuleValue_.dictionaryLnkRule).get(DictionaryLnkRule_.id), (Object)NumberUtils.createLong((String)bc.getParentId()));
    }

    public Actions<DictionaryLnkRuleValueDto> getActions() {
        return Actions.builder().associate().add().delete().add().build();
    }

    protected AssociateResultDTO doAssociate(List<AssociateDTO> data, BusinessComponent bc) {
        DictionaryLnkRule parent = (DictionaryLnkRule)this.baseDAO.findById(DictionaryLnkRule.class, bc.getParentIdAsLong());
        for (AssociateDTO dto : data) {
            if (!dto.getAssociated().booleanValue()) continue;
            DictionaryLnkRuleValue entity = new DictionaryLnkRuleValue();
            entity.setDictionaryLnkRule(parent);
            entity.setChildKey(new LOV(dto.getId()));
            this.baseDAO.save((Object)entity);
        }
        return new AssociateResultDTO(Collections.emptyList()).setAction(PostAction.refreshBc((BcIdentifier)bc));
    }
}

