/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine;

import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.PluralAttribute;
import lombok.Generated;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.api.data.dictionary.SimpleDictionary;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BcIdentifier;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.rowmeta.EngineFieldsMeta;
import org.cxbox.core.service.linkedlov.LinkedDictionaryService;
import org.cxbox.core.ui.BcUtils;
import org.cxbox.model.core.dao.JpaDao;
import org.cxbox.model.dictionary.links.entity.CustomizableResponseService_;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleValue;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRule_;
import org.cxbox.source.engine.LinkedDictionaryConditionChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LinkedDictionaryServiceImpl
implements LinkedDictionaryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LinkedDictionaryServiceImpl.class);
    private final Map<LOV, LinkedDictionaryConditionChecker> conditions;
    @Autowired
    private DictionaryCache dictionaryCache;
    @Autowired
    private LinkedDictionaryCache linkedDictionaryCache;
    @Autowired
    private BcUtils bcUtils;

    public LinkedDictionaryServiceImpl(Optional<List<LinkedDictionaryConditionChecker>> conditionCheckers) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        conditionCheckers.ifPresent(checkers -> {
            for (LinkedDictionaryConditionChecker checker : checkers) {
                builder.put((Object)checker.getType(), (Object)checker);
            }
        });
        this.conditions = builder.build();
    }

    public void fillRowMetaWithLinkedDictionaries(EngineFieldsMeta<?> meta, BusinessComponent bc, boolean filterValues) {
        String serviceName = this.getServiceName(bc);
        Set requiredFields = this.bcUtils.getBcFieldsForCurrentScreen((BcIdentifier)bc);
        Map<String, List<DictionaryLnkRule>> rulesByField = this.linkedDictionaryCache.getRules(serviceName);
        rulesByField.forEach((field, fieldRules) -> {
            if (requiredFields.contains(field)) {
                this.processRules(meta, bc, (List<DictionaryLnkRule>)fieldRules, filterValues);
            }
        });
    }

    private void processRules(EngineFieldsMeta<?> meta, BusinessComponent bc, List<DictionaryLnkRule> rules, boolean filterValues) {
        Map<Boolean, Map<Boolean, List<DictionaryLnkRule>>> ruleMap = rules.stream().collect(Collectors.partitioningBy(DictionaryLnkRule::isDefaultRuleFlg, Collectors.partitioningBy(DictionaryLnkRule::isFilterableField)));
        if (!filterValues && !this.processRules(ruleMap.get(false).get(false), meta, bc)) {
            this.processRules(ruleMap.get(true).get(false), meta, bc);
        }
        if (!this.processRules(ruleMap.get(false).get(true), meta, bc)) {
            this.processRules(ruleMap.get(true).get(true), meta, bc);
        }
    }

    private String getServiceName(BusinessComponent bc) {
        if (bc.getDescription() instanceof InnerBcDescription) {
            InnerBcDescription innerBcDescription = (InnerBcDescription)bc.getDescription();
            return innerBcDescription.getServiceClass().getSimpleName();
        }
        return bc.getDescription().getCrudmaService().getSimpleName();
    }

    public Set<LOV> getDictionariesForField(DtoField field, BusinessComponent bc, boolean filterValues) {
        String serviceName = ((InnerBcDescription)bc.getDescription()).getServiceClass().getSimpleName();
        List rules = this.linkedDictionaryCache.getRules(serviceName).getOrDefault(field.getName(), Collections.emptyList()).stream().filter(rule -> filterValues == rule.isFilterableField()).collect(Collectors.toList());
        HashSet<LOV> result = new HashSet<LOV>();
        long ruleMatchCount = rules.stream().filter(rule -> !rule.isDefaultRuleFlg() && this.processRule((DictionaryLnkRule)rule, (Set<LOV>)result, bc)).count();
        if (ruleMatchCount < 1L) {
            rules.stream().filter(DictionaryLnkRule::isDefaultRuleFlg).findFirst().ifPresent(rule -> this.processRule((DictionaryLnkRule)rule, (Set<LOV>)result, bc));
        }
        return result;
    }

    private boolean processRule(DictionaryLnkRule rule, Set<LOV> ruleValues, BusinessComponent bc) {
        LinkedHashSet<LOV> lovs = new LinkedHashSet<LOV>();
        boolean result = this.processRule(rule, bc, lovs);
        if (result) {
            ruleValues.addAll(lovs);
        }
        return result;
    }

    private boolean processRules(List<DictionaryLnkRule> rules, EngineFieldsMeta<?> meta, BusinessComponent bc) {
        if (rules.isEmpty()) {
            return false;
        }
        String type = rules.get(0).getType();
        String field = rules.get(0).getField();
        boolean isFilterableField = rules.get(0).isFilterableField();
        boolean anyApplied = false;
        HashSet<LOV> allLovs = new HashSet<LOV>();
        for (DictionaryLnkRule rule : rules) {
            HashSet<LOV> lovs;
            if (!this.processRule(rule, bc, lovs = new HashSet<LOV>())) continue;
            anyApplied = true;
            allLovs.addAll(lovs);
        }
        List values = allLovs.stream().map(lov -> this.dictionaryCache.get(type, lov.getKey())).filter(Objects::nonNull).sorted(Comparator.comparingInt(SimpleDictionary::getDisplayOrder)).collect(Collectors.toList());
        if (anyApplied) {
            if (isFilterableField) {
                meta.addEngineFilterValues(field, values);
            } else {
                meta.addEngineConcreteValues(field, values);
            }
        }
        return anyApplied;
    }

    private boolean processRule(DictionaryLnkRule rule, BusinessComponent bc, Set<LOV> lovs) {
        if (rule.getField() == null || rule.getType() == null) {
            return false;
        }
        if (!this.processRuleAllConditions(bc, rule)) {
            return false;
        }
        if (rule.isAllValues()) {
            this.dictionaryCache.getAll(rule.getType()).stream().map(SimpleDictionary::getKey).map(LOV::new).forEach(lovs::add);
        } else {
            rule.getValues().stream().map(DictionaryLnkRuleValue::getChildKey).forEach(lovs::add);
        }
        return true;
    }

    private boolean processRuleAllConditions(BusinessComponent bc, DictionaryLnkRule rule) {
        for (DictionaryLnkRuleCond ruleCondition : rule.getConditions()) {
            if (this.processRuleCond(bc, ruleCondition)) continue;
            return false;
        }
        return true;
    }

    private boolean processRuleCond(BusinessComponent bc, DictionaryLnkRuleCond ruleCondition) {
        try {
            LinkedDictionaryConditionChecker conditionChecker = this.conditions.get(ruleCondition.getType());
            if (conditionChecker == null || !conditionChecker.accept(ruleCondition, bc)) {
                return false;
            }
            boolean result = conditionChecker.check(conditionChecker.prepare(ruleCondition, bc), ruleCondition);
            if (ruleCondition.isRuleInversionFlg()) {
                result = !result;
            }
            return result;
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    @Component
    public static class LinkedDictionaryCache {
        private final JpaDao jpaDao;

        @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"linkedDictionaryRules"}, key="{#root.methodName, #serviceName}")
        public Map<String, List<DictionaryLnkRule>> getRules(String serviceName) {
            return this.jpaDao.getList(DictionaryLnkRule.class, (Specification & Serializable)(root, cq, cb) -> {
                root.fetch((PluralAttribute)DictionaryLnkRule_.conditions, JoinType.LEFT);
                root.fetch((PluralAttribute)DictionaryLnkRule_.values, JoinType.LEFT);
                return cb.and((Expression)cb.equal((Expression)root.get(DictionaryLnkRule_.service).get(CustomizableResponseService_.serviceName), (Object)serviceName), (Expression)cb.isNotNull((Expression)root.get(DictionaryLnkRule_.type)));
            }).stream().distinct().map(arg_0 -> ((JpaDao)this.jpaDao).evict(arg_0)).collect(Collectors.groupingBy(DictionaryLnkRule::getField));
        }

        @CacheEvict(cacheResolver="cxboxCacheResolver", value={"linkedDictionaryRules"}, allEntries=true)
        public void evictRules() {
        }

        @ConstructorProperties(value={"jpaDao"})
        @Generated
        public LinkedDictionaryCache(JpaDao jpaDao) {
            this.jpaDao = jpaDao;
        }
    }
}

