/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine.condition;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.DictionaryCache;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.service.spec.ResponseServiceExtractor;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.source.engine.LinkedDictionaryConditionChecker;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="DictionaryFieldLinkedDictionaryConditionChecker")
public class DictionaryFieldLinkedDictionaryConditionChecker
implements LinkedDictionaryConditionChecker<LOV> {
    private final DictionaryCache dictionaryCache;
    private final ResponseServiceExtractor responseServiceExtractor;

    @Override
    public LOV getType() {
        return CoreDictionaries.DictionaryTermType.DICTIONARY_FIELD;
    }

    @Override
    public boolean check(LOV object, DictionaryLnkRuleCond ruleCond) {
        return object != null && Objects.equals(object, ruleCond.getFieldDictValue());
    }

    @Override
    public boolean accept(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return ruleCond.getFieldName() != null && ruleCond.getFieldDictValue() != null;
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, keyGenerator="conditionKeyGenerator")
    public LOV prepare(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        Object value = this.responseServiceExtractor.getFieldValue(bc, ruleCond.getFieldName());
        if (value != null) {
            return this.dictionaryCache.lookupName((String)value, ruleCond.getFieldType());
        }
        return null;
    }

    @ConstructorProperties(value={"dictionaryCache", "responseServiceExtractor"})
    @Generated
    public DictionaryFieldLinkedDictionaryConditionChecker(DictionaryCache dictionaryCache, ResponseServiceExtractor responseServiceExtractor) {
        this.dictionaryCache = dictionaryCache;
        this.responseServiceExtractor = responseServiceExtractor;
    }
}

