/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine.condition;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.service.spec.ResponseServiceExtractor;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.source.engine.LinkedDictionaryConditionChecker;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="TextFieldLinkedDictionaryConditionChecker")
public class TextFieldLinkedDictionaryConditionChecker
implements LinkedDictionaryConditionChecker<String> {
    private final ResponseServiceExtractor responseServiceExtractor;

    @Override
    public LOV getType() {
        return CoreDictionaries.DictionaryTermType.TEXT_FIELD;
    }

    @Override
    public boolean check(String object, DictionaryLnkRuleCond ruleCond) {
        return object != null && Objects.equals(object, ruleCond.getFieldTextValue());
    }

    @Override
    public boolean accept(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return ruleCond.getFieldName() != null && ruleCond.getFieldTextValue() != null;
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, keyGenerator="conditionKeyGenerator")
    public String prepare(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return (String)this.responseServiceExtractor.getFieldValue(bc, ruleCond.getFieldName());
    }

    @ConstructorProperties(value={"responseServiceExtractor"})
    @Generated
    public TextFieldLinkedDictionaryConditionChecker(ResponseServiceExtractor responseServiceExtractor) {
        this.responseServiceExtractor = responseServiceExtractor;
    }
}

