/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine;

import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import lombok.Generated;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cxbox.api.data.dto.DataResponseDTO;
import org.cxbox.constgen.DtoField;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.core.crudma.bc.impl.InnerBcDescription;
import org.cxbox.core.dto.DTOUtils;
import org.cxbox.core.service.DTOMapper;
import org.cxbox.core.service.ResponseService;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ResponseServiceExtractor {
    private final DTOMapper dtoMapper;
    private final ApplicationContext applicationContext;

    private ResponseService<DataResponseDTO, BaseEntity> getResponseService(BusinessComponent bc) {
        if (bc.getId() == null) {
            return null;
        }
        if (!(bc.getDescription() instanceof InnerBcDescription)) {
            return null;
        }
        InnerBcDescription innerBcDescription = (InnerBcDescription)bc.getDescription();
        Class serviceClass = innerBcDescription.getServiceClass();
        return (ResponseService)this.applicationContext.getBean(serviceClass);
    }

    public Object getFieldValue(BusinessComponent bc, String fieldName) {
        Object result;
        ResponseService<DataResponseDTO, BaseEntity> responseService = this.getResponseService(bc);
        if (responseService == null) {
            return null;
        }
        Class dtoClass = responseService.getTypeOfDTO();
        Field field = FieldUtils.getField((Class)dtoClass, (String)fieldName, (boolean)true);
        if (field == null) {
            return null;
        }
        DtoField dtoField = DTOUtils.getField((Class)dtoClass, (String)fieldName);
        if (dtoField == null) {
            return null;
        }
        DataResponseDTO dto = responseService.getOne(bc);
        if (dto == null || !dto.isFieldComputed(fieldName)) {
            DataResponseDTO partial = this.dtoMapper.entityToDto(responseService.getOneAsEntity(bc), dtoClass, dtoField);
            result = field.get(partial);
            if (dto != null && !dto.isFieldComputed(fieldName)) {
                field.set(dto, result);
                dto.addComputedField(fieldName);
            }
        } else {
            result = field.get(dto);
        }
        return result;
    }

    @ConstructorProperties(value={"dtoMapper", "applicationContext"})
    @Generated
    public ResponseServiceExtractor(DTOMapper dtoMapper, ApplicationContext applicationContext) {
        this.dtoMapper = dtoMapper;
        this.applicationContext = applicationContext;
    }
}

