/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine.condition;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.source.engine.LinkedDictionaryConditionChecker;
import org.cxbox.source.engine.ResponseServiceExtractor;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="BooleanFieldLinkedDictionaryConditionChecker")
public class BooleanFieldLinkedDictionaryConditionChecker
implements LinkedDictionaryConditionChecker<Boolean> {
    private final ResponseServiceExtractor responseServiceExtractor;

    @Override
    public LOV getType() {
        return CoreDictionaries.DictionaryTermType.BOOLEAN_FIELD;
    }

    @Override
    public boolean check(Boolean object, DictionaryLnkRuleCond ruleCond) {
        return object != null && Objects.equals(object, ruleCond.getFieldBooleanValue());
    }

    @Override
    public boolean accept(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return ruleCond.getFieldName() != null && ruleCond.getFieldBooleanValue() != null;
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, keyGenerator="conditionKeyGenerator")
    public Boolean prepare(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return (Boolean)this.responseServiceExtractor.getFieldValue(bc, ruleCond.getFieldName());
    }

    @ConstructorProperties(value={"responseServiceExtractor"})
    @Generated
    public BooleanFieldLinkedDictionaryConditionChecker(ResponseServiceExtractor responseServiceExtractor) {
        this.responseServiceExtractor = responseServiceExtractor;
    }
}

