/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.source.engine.condition;

import java.beans.ConstructorProperties;
import java.util.Objects;
import lombok.Generated;
import org.cxbox.api.data.dictionary.CoreDictionaries;
import org.cxbox.api.data.dictionary.LOV;
import org.cxbox.core.crudma.bc.BusinessComponent;
import org.cxbox.model.dictionary.links.entity.DictionaryLnkRuleCond;
import org.cxbox.source.engine.LinkedDictionaryConditionChecker;
import org.cxbox.source.engine.ResponseServiceExtractor;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="FieldIsNullLinkedDictionaryConditionChecker")
public class FieldIsNullLinkedDictionaryConditionChecker
implements LinkedDictionaryConditionChecker<Object> {
    private final ResponseServiceExtractor responseServiceExtractor;

    @Override
    public LOV getType() {
        return CoreDictionaries.DictionaryTermType.FIELD_IS_EMPTY;
    }

    @Override
    public boolean check(Object object, DictionaryLnkRuleCond ruleCond) {
        return object == null || Objects.equals(object, "");
    }

    @Override
    public boolean accept(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return ruleCond.getFieldName() != null;
    }

    @Override
    @Cacheable(cacheResolver="cxboxCacheResolver", cacheNames={"requestCache"}, keyGenerator="conditionKeyGenerator")
    public Object prepare(DictionaryLnkRuleCond ruleCond, BusinessComponent bc) {
        return this.responseServiceExtractor.getFieldValue(bc, ruleCond.getFieldName());
    }

    @ConstructorProperties(value={"responseServiceExtractor"})
    @Generated
    public FieldIsNullLinkedDictionaryConditionChecker(ResponseServiceExtractor responseServiceExtractor) {
        this.responseServiceExtractor = responseServiceExtractor;
    }
}

