/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.dictionary.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapKey;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.cxbox.model.core.api.Translatable;
import org.cxbox.model.core.entity.BaseEntity;
import org.cxbox.model.dictionary.entity.DictionaryItemTranslation;
import org.cxbox.model.dictionary.entity.DictionaryTypeDesc;
import org.hibernate.type.NumericBooleanConverter;

@Entity
@Table(name="DICTIONARY_ITEM", uniqueConstraints={@UniqueConstraint(name="DIC_SELECT_UNIQUE_TYPE_KEY", columnNames={"type", "key"}), @UniqueConstraint(name="DIC_SELECT_UNIQUE_TYPE_VALUE", columnNames={"type", "value"})})
public class DictionaryItem
extends BaseEntity
implements Translatable<DictionaryItem, DictionaryItemTranslation>,
Serializable {
    public static final String CONSTRAINT_UNIQ_TYPE_KEY = "DIC_SELECT_UNIQUE_TYPE_KEY";
    public static final String CONSTRAINT_UNIQ_TYPE_VALUE = "DIC_SELECT_UNIQUE_TYPE_VALUE";
    @Column
    private String type;
    @Column
    private String key;
    @Column
    private String value;
    @Column
    private boolean active;
    @Column
    private Integer displayOrder;
    @Column
    private String description;
    @Column(name="ADDITION_FLG")
    @Convert(converter=NumericBooleanConverter.class)
    private Boolean additionFlg;
    @ManyToOne
    @JoinColumn(name="DICTIONARY_TYPE_ID")
    private DictionaryTypeDesc dictionaryTypeId;
    @OneToMany(mappedBy="primaryEntity", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, orphanRemoval=true)
    @MapKey(name="translationId.language")
    private Map<String, DictionaryItemTranslation> translations;

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public Integer getDisplayOrder() {
        return this.displayOrder;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getAdditionFlg() {
        return this.additionFlg;
    }

    @Generated
    public DictionaryTypeDesc getDictionaryTypeId() {
        return this.dictionaryTypeId;
    }

    @Generated
    public Map<String, DictionaryItemTranslation> getTranslations() {
        return this.translations;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAdditionFlg(Boolean additionFlg) {
        this.additionFlg = additionFlg;
    }

    @Generated
    public void setDictionaryTypeId(DictionaryTypeDesc dictionaryTypeId) {
        this.dictionaryTypeId = dictionaryTypeId;
    }

    @Generated
    public void setTranslations(Map<String, DictionaryItemTranslation> translations) {
        this.translations = translations;
    }

    @Generated
    public DictionaryItem() {
    }

    @ConstructorProperties(value={"type", "key", "value", "active", "displayOrder", "description", "additionFlg", "dictionaryTypeId", "translations"})
    @Generated
    public DictionaryItem(String type, String key, String value, boolean active, Integer displayOrder, String description, Boolean additionFlg, DictionaryTypeDesc dictionaryTypeId, Map<String, DictionaryItemTranslation> translations) {
        this.type = type;
        this.key = key;
        this.value = value;
        this.active = active;
        this.displayOrder = displayOrder;
        this.description = description;
        this.additionFlg = additionFlg;
        this.dictionaryTypeId = dictionaryTypeId;
        this.translations = translations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DictionaryItem)) {
            return false;
        }
        DictionaryItem other = (DictionaryItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        Integer this$displayOrder = this.getDisplayOrder();
        Integer other$displayOrder = other.getDisplayOrder();
        if (this$displayOrder == null ? other$displayOrder != null : !((Object)this$displayOrder).equals(other$displayOrder)) {
            return false;
        }
        Boolean this$additionFlg = this.getAdditionFlg();
        Boolean other$additionFlg = other.getAdditionFlg();
        if (this$additionFlg == null ? other$additionFlg != null : !((Object)this$additionFlg).equals(other$additionFlg)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        DictionaryTypeDesc this$dictionaryTypeId = this.getDictionaryTypeId();
        DictionaryTypeDesc other$dictionaryTypeId = other.getDictionaryTypeId();
        if (this$dictionaryTypeId == null ? other$dictionaryTypeId != null : !((Object)this$dictionaryTypeId).equals(other$dictionaryTypeId)) {
            return false;
        }
        Map<String, DictionaryItemTranslation> this$translations = this.getTranslations();
        Map<String, DictionaryItemTranslation> other$translations = other.getTranslations();
        return !(this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DictionaryItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isActive() ? 79 : 97);
        Integer $displayOrder = this.getDisplayOrder();
        result = result * 59 + ($displayOrder == null ? 43 : ((Object)$displayOrder).hashCode());
        Boolean $additionFlg = this.getAdditionFlg();
        result = result * 59 + ($additionFlg == null ? 43 : ((Object)$additionFlg).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        DictionaryTypeDesc $dictionaryTypeId = this.getDictionaryTypeId();
        result = result * 59 + ($dictionaryTypeId == null ? 43 : ((Object)$dictionaryTypeId).hashCode());
        Map<String, DictionaryItemTranslation> $translations = this.getTranslations();
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        return result;
    }
}

