/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.api;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.cxbox.api.service.LocaleService;
import org.cxbox.model.core.api.Translation;
import org.cxbox.model.core.entity.BaseEntity;
import org.springframework.context.i18n.LocaleContextHolder;

public interface Translatable<P extends BaseEntity, L extends Translation<P, L>> {
    public Map<String, L> getTranslations();

    default public void addTranslation(L translation) {
        this.getTranslations().put(translation.getLanguage(), translation);
    }

    default public Optional<L> getTranslation() {
        return this.getTranslation(LocaleContextHolder.getLocale().getLanguage(), ((Locale)LocaleService.defaultLocale.get()).getLanguage());
    }

    default public Optional<L> getTranslation(String language, String fallbackLanguage) {
        Map<String, L> translations = this.getTranslations();
        Translation translation = (Translation)translations.get(language);
        if (translation != null) {
            return Optional.of(translation);
        }
        return Optional.ofNullable(fallbackLanguage).map(this.getTranslations()::get);
    }

    default public Class<L> getTranslationType() {
        Map typeArguments = TypeUtils.getTypeArguments(this.getClass(), Translatable.class);
        return Stream.of(Translatable.class.getTypeParameters()).map(typeArguments::get).skip(1L).findFirst().map(Class.class::cast).orElseThrow(IllegalStateException::new);
    }
}

