/*
 * Decompiled with CFR 0.152.
 */
package org.cxbox.model.core.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.support.SimpleTransactionScope;

@Configuration
public class ScopeConfig {
    public static final String TRANSACTION_SCOPE = "tx";

    @Bean
    public static BeanFactoryPostProcessor beanFactoryPostProcessor() {
        return new CustomScopeConfigProcessor();
    }

    private static class CustomScopeConfigProcessor
    implements BeanFactoryPostProcessor {
        private CustomScopeConfigProcessor() {
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            beanFactory.registerScope(ScopeConfig.TRANSACTION_SCOPE, (Scope)new SimpleTransactionScope());
        }
    }
}

